/*
 * Decompiled with CFR 0.152.
 */
package org.h2.table;

import java.sql.SQLException;
import org.h2.command.Prepared;
import org.h2.command.dml.Query;
import org.h2.engine.Session;
import org.h2.engine.User;
import org.h2.expression.Expression;
import org.h2.expression.Parameter;
import org.h2.index.Index;
import org.h2.index.IndexType;
import org.h2.index.ViewIndex;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.schema.Schema;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.PlanItem;
import org.h2.table.Table;
import org.h2.util.IntArray;
import org.h2.util.ObjectArray;
import org.h2.util.SmallLRUCache;
import org.h2.util.StatementBuilder;
import org.h2.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableView
extends Table {
    private static final long ROW_COUNT_APPROXIMATION = 100L;
    private String querySQL;
    private ObjectArray<Table> tables;
    private final String[] columnNames;
    private Query viewQuery;
    private ViewIndex index;
    private boolean recursive;
    private SQLException createException;
    private SmallLRUCache<IntArray, ViewIndex> indexCache = SmallLRUCache.newInstance(64);
    private long lastModificationCheck;
    private long maxDataModificationId;
    private User owner;
    private Query topQuery;

    public TableView(Schema schema, int n, String string, String string2, ObjectArray<Parameter> objectArray, String[] stringArray, Session session, boolean bl) throws SQLException {
        super(schema, n, string, false, true);
        this.querySQL = string2;
        this.columnNames = stringArray;
        this.recursive = bl;
        this.index = new ViewIndex(this, string2, objectArray, bl);
        this.initColumnsAndTables(session);
    }

    public Query recompileQuery(Session session) throws SQLException {
        Prepared prepared = session.prepare(this.querySQL);
        if (!(prepared instanceof Query)) {
            throw Message.getSyntaxError(this.querySQL, 0);
        }
        Query query = (Query)prepared;
        this.querySQL = query.getPlanSQL();
        return query;
    }

    private void initColumnsAndTables(Session session) throws SQLException {
        Object[] objectArray;
        block7: {
            this.removeViewFromTables();
            try {
                Query query = this.recompileQuery(session);
                this.tables = ObjectArray.newInstance(query.getTables());
                ObjectArray<Expression> objectArray2 = query.getExpressions();
                ObjectArray<Column> objectArray3 = ObjectArray.newInstance();
                for (int i = 0; i < query.getColumnCount(); ++i) {
                    Expression expression = objectArray2.get(i);
                    String string = null;
                    if (this.columnNames != null && this.columnNames.length > i) {
                        string = this.columnNames[i];
                    }
                    if (string == null) {
                        string = expression.getAlias();
                    }
                    int n = expression.getType();
                    long l = expression.getPrecision();
                    int n2 = expression.getScale();
                    int n3 = expression.getDisplaySize();
                    Column column = new Column(string, n, l, n2, n3);
                    column.setTable(this, i);
                    objectArray3.add(column);
                }
                objectArray = new Column[objectArray3.size()];
                objectArray3.toArray(objectArray);
                this.createException = null;
                this.viewQuery = query;
            }
            catch (SQLException sQLException) {
                this.createException = sQLException;
                this.tables = ObjectArray.newInstance();
                objectArray = new Column[]{};
                if (!this.recursive || this.columnNames == null) break block7;
                objectArray = new Column[this.columnNames.length];
                for (int i = 0; i < this.columnNames.length; ++i) {
                    objectArray[i] = new Column(this.columnNames[i], 13);
                }
                this.index.setRecursive(true);
                this.recursive = true;
                this.createException = null;
            }
        }
        this.setColumns((Column[])objectArray);
        if (this.getId() != 0) {
            this.addViewToTables();
        }
    }

    public boolean getInvalid() {
        return this.createException != null;
    }

    @Override
    public PlanItem getBestPlanItem(Session session, int[] nArray) throws SQLException {
        PlanItem planItem = new PlanItem();
        planItem.cost = this.index.getCost(session, nArray);
        IntArray intArray = new IntArray(nArray == null ? new int[]{} : nArray);
        ViewIndex viewIndex = (ViewIndex)this.indexCache.get(intArray);
        if (viewIndex == null || viewIndex.getSession() != session) {
            viewIndex = new ViewIndex(this, this.index, session, nArray);
            this.indexCache.put(intArray, viewIndex);
        }
        planItem.setIndex(viewIndex);
        return planItem;
    }

    @Override
    public String getDropSQL() {
        return "DROP VIEW IF EXISTS " + this.getSQL();
    }

    @Override
    public String getCreateSQL() {
        StatementBuilder statementBuilder = new StatementBuilder("CREATE FORCE VIEW ");
        statementBuilder.append(this.getSQL());
        if (this.comment != null) {
            statementBuilder.append(" COMMENT ").append(StringUtils.quoteStringSQL(this.comment));
        }
        if (this.columns.length > 0) {
            statementBuilder.append('(');
            for (Column column : this.columns) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append(column.getSQL());
            }
            statementBuilder.append(')');
        } else if (this.columnNames != null) {
            statementBuilder.append('(');
            for (String string : this.columnNames) {
                statementBuilder.appendExceptFirst(", ");
                statementBuilder.append(string);
            }
            statementBuilder.append(')');
        }
        return statementBuilder.append(" AS\n").append(this.querySQL).toString();
    }

    @Override
    public void checkRename() {
    }

    @Override
    public void lock(Session session, boolean bl, boolean bl2) {
    }

    @Override
    public void close(Session session) {
    }

    @Override
    public void unlock(Session session) {
    }

    @Override
    public boolean isLockedExclusively() {
        return false;
    }

    @Override
    public Index addIndex(Session session, String string, int n, IndexColumn[] indexColumnArray, IndexType indexType, int n2, String string2) throws SQLException {
        throw Message.getUnsupportedException("VIEW");
    }

    @Override
    public void removeRow(Session session, Row row) throws SQLException {
        throw Message.getUnsupportedException("VIEW");
    }

    @Override
    public void addRow(Session session, Row row) throws SQLException {
        throw Message.getUnsupportedException("VIEW");
    }

    @Override
    public void checkSupportAlter() throws SQLException {
        throw Message.getUnsupportedException("VIEW");
    }

    @Override
    public void truncate(Session session) throws SQLException {
        throw Message.getUnsupportedException("VIEW");
    }

    @Override
    public long getRowCount(Session session) {
        throw Message.throwInternalError();
    }

    @Override
    public boolean canGetRowCount() {
        return false;
    }

    @Override
    public boolean canDrop() {
        return true;
    }

    @Override
    public String getTableType() {
        return "VIEW";
    }

    @Override
    public void removeChildrenAndResources(Session session) throws SQLException {
        this.removeViewFromTables();
        super.removeChildrenAndResources(session);
        this.database.removeMeta(session, this.getId());
        this.querySQL = null;
        this.index = null;
        this.invalidate();
    }

    @Override
    public String getSQL() {
        if (this.getTemporary()) {
            return "(" + this.querySQL + ")";
        }
        return super.getSQL();
    }

    @Override
    public Index getScanIndex(Session session) throws SQLException {
        if (this.createException != null) {
            String string = this.createException.getMessage();
            throw Message.getSQLException(90109, new String[]{this.getSQL(), string}, this.createException);
        }
        PlanItem planItem = this.getBestPlanItem(session, null);
        return planItem.getIndex();
    }

    @Override
    public ObjectArray<Index> getIndexes() {
        return null;
    }

    public void recompile(Session session) throws SQLException {
        for (Table table : this.tables) {
            table.removeView(this);
        }
        this.tables.clear();
        this.initColumnsAndTables(session);
    }

    @Override
    public long getMaxDataModificationId() {
        if (this.createException != null) {
            return Long.MAX_VALUE;
        }
        if (this.viewQuery == null) {
            return Long.MAX_VALUE;
        }
        long l = this.database.getModificationDataId();
        if (l > this.lastModificationCheck && this.maxDataModificationId <= l) {
            this.maxDataModificationId = this.viewQuery.getMaxDataModificationId();
            this.lastModificationCheck = l;
        }
        return this.maxDataModificationId;
    }

    @Override
    public Index getUniqueIndex() {
        return null;
    }

    private void removeViewFromTables() {
        if (this.tables != null) {
            for (Table table : this.tables) {
                table.removeView(this);
            }
            this.tables.clear();
        }
    }

    private void addViewToTables() {
        for (Table table : this.tables) {
            table.addView(this);
        }
    }

    private void setOwner(User user) {
        this.owner = user;
    }

    public User getOwner() {
        return this.owner;
    }

    public static TableView createTempView(Session session, User user, String string, Query query, Query query2) throws SQLException {
        Schema schema = session.getDatabase().getSchema("PUBLIC");
        String string2 = query.getPlanSQL();
        TableView tableView = new TableView(schema, 0, string, string2, query.getParameters(), null, session, false);
        tableView.setTopQuery(query2);
        if (tableView.createException != null) {
            throw tableView.createException;
        }
        tableView.setOwner(user);
        tableView.setTemporary(true);
        return tableView;
    }

    private void setTopQuery(Query query) {
        this.topQuery = query;
    }

    @Override
    public long getRowCountApproximation() {
        return 100L;
    }

    public int getParameterOffset() {
        return this.topQuery == null ? 0 : this.topQuery.getParameters().size();
    }
}

