/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.message.Message;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.store.FileStoreInputStream;
import org.h2.store.FileStoreOutputStream;
import org.h2.store.fs.FileSystem;
import org.h2.util.ByteUtils;
import org.h2.util.FileUtils;
import org.h2.util.IOUtils;
import org.h2.util.MathUtils;
import org.h2.util.SmallLRUCache;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;

public class ValueLob
extends Value {
    public static final int TABLE_ID_SESSION_VARIABLE = -1;
    private static int dirCounter;
    private final int type;
    private long precision;
    private DataHandler handler;
    private int tableId;
    private int objectId;
    private String fileName;
    private boolean linked;
    private byte[] small;
    private int hash;
    private boolean compression;
    private FileStore tempFile;

    private ValueLob(int n, DataHandler dataHandler, String string, int n2, int n3, boolean bl, long l, boolean bl2) {
        this.type = n;
        this.handler = dataHandler;
        this.fileName = string;
        this.tableId = n2;
        this.objectId = n3;
        this.linked = bl;
        this.precision = l;
        this.compression = bl2;
    }

    private ValueLob(int n, byte[] byArray) {
        this.type = n;
        this.small = byArray;
        if (byArray != null) {
            this.precision = n == 15 ? (long)byArray.length : (long)this.getString().length();
        }
    }

    private static ValueLob copy(ValueLob valueLob) {
        ValueLob valueLob2 = new ValueLob(valueLob.type, valueLob.handler, valueLob.fileName, valueLob.tableId, valueLob.objectId, valueLob.linked, valueLob.precision, valueLob.compression);
        valueLob2.small = valueLob.small;
        valueLob2.hash = valueLob.hash;
        return valueLob2;
    }

    public static ValueLob createSmallLob(int n, byte[] byArray) {
        return new ValueLob(n, byArray);
    }

    private static String getFileName(DataHandler dataHandler, int n, int n2) {
        if (SysProperties.CHECK && n == 0 && n2 == 0) {
            Message.throwInternalError("0 LOB");
        }
        if (dataHandler.getLobFilesInDirectories()) {
            String string = n < 0 ? ".temp" : ".t" + n;
            return ValueLob.getFileNamePrefix(dataHandler.getDatabasePath(), n2) + string + ".lob.db";
        }
        return dataHandler.getDatabasePath() + "." + n + "." + n2 + ".lob.db";
    }

    public static ValueLob open(int n, DataHandler dataHandler, int n2, int n3, long l, boolean bl) {
        String string = ValueLob.getFileName(dataHandler, n2, n3);
        return new ValueLob(n, dataHandler, string, n2, n3, true, l, bl);
    }

    public static ValueLob createClob(Reader reader, long l, DataHandler dataHandler) throws SQLException {
        try {
            char[] cArray;
            Object object;
            int n;
            boolean bl = dataHandler.getLobCompressionAlgorithm(16) != null;
            long l2 = Long.MAX_VALUE;
            if (l >= 0L && l < l2) {
                l2 = l;
            }
            if ((n = ValueLob.getBufferSize(dataHandler, bl, l2)) >= Integer.MAX_VALUE) {
                object = IOUtils.readStringAndClose(reader, -1);
                cArray = ((String)object).toCharArray();
                n = cArray.length;
            } else {
                cArray = new char[n];
                int n2 = n = (n = IOUtils.readFully(reader, cArray, n)) < 0 ? 0 : n;
            }
            if (n <= dataHandler.getMaxLengthInplaceLob()) {
                object = StringUtils.utf8Encode(new String(cArray, 0, n));
                return ValueLob.createSmallLob(16, (byte[])object);
            }
            object = new ValueLob(16, null);
            super.createFromReader(cArray, n, reader, l2, dataHandler);
            return object;
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }

    private static int getBufferSize(DataHandler dataHandler, boolean bl, long l) {
        long l2;
        long l3;
        if (l < 0L || l > Integer.MAX_VALUE) {
            l = Integer.MAX_VALUE;
        }
        if ((l3 = (long)dataHandler.getMaxLengthInplaceLob()) >= Integer.MAX_VALUE) {
            l3 = l;
        }
        long l4 = l2 = bl ? 131072L : 4096L;
        if (l2 < l && l2 <= l3) {
            l2 = Math.min(l, l3 + 1L);
            l2 = MathUtils.roundUpLong(l2, 4096L);
        }
        l2 = Math.min(l, l2);
        if ((l2 = (long)MathUtils.convertLongToInt(l2)) < 0L) {
            l2 = Integer.MAX_VALUE;
        }
        return (int)l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFromReader(char[] cArray, int n, Reader reader, long l, DataHandler dataHandler) throws SQLException {
        try {
            FileStoreOutputStream fileStoreOutputStream = this.initLarge(dataHandler);
            boolean bl = dataHandler.getLobCompressionAlgorithm(16) != null;
            try {
                do {
                    this.precision += (long)n;
                    byte[] byArray = StringUtils.utf8Encode(new String(cArray, 0, n));
                    fileStoreOutputStream.write(byArray, 0, byArray.length);
                    if ((l -= (long)n) <= 0L) {
                        break;
                    }
                    n = ValueLob.getBufferSize(dataHandler, bl, l);
                } while ((n = IOUtils.readFully(reader, cArray, n)) > 0);
            }
            finally {
                fileStoreOutputStream.close();
            }
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }

    private static String getFileNamePrefix(String string, int n) {
        int n2 = n % SysProperties.LOB_FILES_PER_DIRECTORY;
        String string2 = n2 > 0 ? File.separator + n : "";
        n /= SysProperties.LOB_FILES_PER_DIRECTORY;
        while (n > 0) {
            n2 = n % SysProperties.LOB_FILES_PER_DIRECTORY;
            string2 = File.separator + n2 + ".lobs.db" + string2;
            n /= SysProperties.LOB_FILES_PER_DIRECTORY;
        }
        string2 = string + ".lobs.db" + string2;
        return string2;
    }

    private int getNewObjectId(DataHandler dataHandler) throws SQLException {
        int n;
        String string;
        String string2 = dataHandler.getDatabasePath();
        int n2 = 0;
        while (true) {
            string = ValueLob.getFileNamePrefix(string2, n2);
            String[] stringArray = this.getFileList(dataHandler, string);
            int n3 = 0;
            boolean[] blArray = new boolean[SysProperties.LOB_FILES_PER_DIRECTORY];
            String[] stringArray2 = stringArray;
            int n4 = stringArray2.length;
            for (int i = 0; i < n4; ++i) {
                int n5;
                String string3 = stringArray2[i];
                if (!string3.endsWith(".db")) continue;
                string3 = string3.substring(string3.lastIndexOf(File.separatorChar) + 1);
                String string4 = string3.substring(0, string3.indexOf(46));
                try {
                    n5 = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    n5 = -1;
                }
                if (n5 <= 0) continue;
                ++n3;
                blArray[n5 % SysProperties.LOB_FILES_PER_DIRECTORY] = true;
            }
            n = -1;
            if (n3 < SysProperties.LOB_FILES_PER_DIRECTORY) {
                for (n4 = 1; n4 < SysProperties.LOB_FILES_PER_DIRECTORY; ++n4) {
                    if (blArray[n4]) continue;
                    n = n4;
                    break;
                }
            }
            if (n > 0) break;
            if (n2 > Integer.MAX_VALUE / SysProperties.LOB_FILES_PER_DIRECTORY) {
                n2 = 0;
                continue;
            }
            n4 = dirCounter++ / (SysProperties.LOB_FILES_PER_DIRECTORY - 1) + 1;
            n2 *= SysProperties.LOB_FILES_PER_DIRECTORY;
            n2 += n4 * SysProperties.LOB_FILES_PER_DIRECTORY;
        }
        this.invalidateFileList(dataHandler, string);
        return n2 += n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateFileList(DataHandler dataHandler, String string) {
        SmallLRUCache<String, String[]> smallLRUCache = dataHandler.getLobFileListCache();
        if (smallLRUCache != null) {
            SmallLRUCache<String, String[]> smallLRUCache2 = smallLRUCache;
            synchronized (smallLRUCache2) {
                smallLRUCache.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getFileList(DataHandler dataHandler, String string) throws SQLException {
        String[] stringArray;
        SmallLRUCache<String, String[]> smallLRUCache = dataHandler.getLobFileListCache();
        if (smallLRUCache == null) {
            stringArray = FileUtils.listFiles(string);
        } else {
            SmallLRUCache<String, String[]> smallLRUCache2 = smallLRUCache;
            synchronized (smallLRUCache2) {
                stringArray = (String[])smallLRUCache.get(string);
                if (stringArray == null) {
                    stringArray = FileUtils.listFiles(string);
                    smallLRUCache.put(string, stringArray);
                }
            }
        }
        return stringArray;
    }

    public static ValueLob createBlob(InputStream inputStream, long l, DataHandler dataHandler) throws SQLException {
        try {
            byte[] byArray;
            int n;
            boolean bl;
            long l2 = Long.MAX_VALUE;
            boolean bl2 = bl = dataHandler.getLobCompressionAlgorithm(15) != null;
            if (l >= 0L && l < l2) {
                l2 = l;
            }
            if ((n = ValueLob.getBufferSize(dataHandler, bl, l2)) >= Integer.MAX_VALUE) {
                byArray = IOUtils.readBytesAndClose(inputStream, -1);
                n = byArray.length;
            } else {
                byArray = ByteUtils.newBytes(n);
                n = IOUtils.readFully(inputStream, byArray, 0, n);
            }
            if (n <= dataHandler.getMaxLengthInplaceLob()) {
                byte[] byArray2 = ByteUtils.newBytes(n);
                System.arraycopy(byArray, 0, byArray2, 0, n);
                return ValueLob.createSmallLob(15, byArray2);
            }
            ValueLob valueLob = new ValueLob(15, null);
            valueLob.createFromStream(byArray, n, inputStream, l2, dataHandler);
            return valueLob;
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileStoreOutputStream initLarge(DataHandler dataHandler) throws SQLException {
        this.handler = dataHandler;
        this.tableId = 0;
        this.linked = false;
        this.precision = 0L;
        this.small = null;
        this.hash = 0;
        String string = dataHandler.getLobCompressionAlgorithm(this.type);
        this.compression = string != null;
        Object object = dataHandler;
        synchronized (object) {
            if (dataHandler.getLobFilesInDirectories()) {
                this.objectId = this.getNewObjectId(dataHandler);
                this.fileName = ValueLob.getFileNamePrefix(dataHandler.getDatabasePath(), this.objectId) + ".temp.db";
            } else {
                this.objectId = dataHandler.allocateObjectId(false, true);
                this.fileName = dataHandler.createTempFile();
            }
            this.tempFile = dataHandler.openFile(this.fileName, "rw", false);
            this.tempFile.autoDelete();
        }
        object = new FileStoreOutputStream(this.tempFile, dataHandler, string);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createFromStream(byte[] byArray, int n, InputStream inputStream, long l, DataHandler dataHandler) throws SQLException {
        try {
            FileStoreOutputStream fileStoreOutputStream = this.initLarge(dataHandler);
            boolean bl = dataHandler.getLobCompressionAlgorithm(15) != null;
            try {
                do {
                    this.precision += (long)n;
                    fileStoreOutputStream.write(byArray, 0, n);
                    if ((l -= (long)n) <= 0L) {
                        break;
                    }
                    n = ValueLob.getBufferSize(dataHandler, bl, l);
                } while ((n = IOUtils.readFully(inputStream, byArray, 0, n)) > 0);
            }
            finally {
                fileStoreOutputStream.close();
            }
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, null);
        }
    }

    public Value convertTo(int n) throws SQLException {
        if (n == this.type) {
            return this;
        }
        if (n == 16) {
            ValueLob valueLob = ValueLob.createClob(this.getReader(), -1L, this.handler);
            return valueLob;
        }
        if (n == 15) {
            ValueLob valueLob = ValueLob.createBlob(this.getInputStream(), -1L, this.handler);
            return valueLob;
        }
        return super.convertTo(n);
    }

    public boolean isLinked() {
        return this.linked;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void close() throws SQLException {
        if (this.fileName != null) {
            if (this.tempFile != null) {
                this.tempFile.stopAutoDelete();
            }
            ValueLob.deleteFile(this.handler, this.fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlink() throws SQLException {
        if (this.linked && this.fileName != null) {
            DataHandler dataHandler = this.handler;
            synchronized (dataHandler) {
                String string = this.handler.getLobFilesInDirectories() ? ValueLob.getFileName(this.handler, -1, this.objectId) : this.handler.createTempFile();
                ValueLob.deleteFile(this.handler, string);
                ValueLob.renameFile(this.handler, this.fileName, string);
                this.tempFile = FileStore.open(this.handler, string, "rw");
                this.tempFile.autoDelete();
                this.tempFile.closeSilently();
                this.fileName = string;
                this.linked = false;
            }
        }
    }

    public Value link(DataHandler dataHandler, int n) throws SQLException {
        if (this.fileName == null) {
            this.tableId = n;
            return this;
        }
        if (this.linked) {
            ValueLob valueLob = ValueLob.copy(this);
            valueLob.objectId = dataHandler.getLobFilesInDirectories() ? this.getNewObjectId(dataHandler) : dataHandler.allocateObjectId(false, true);
            valueLob.tableId = n;
            String string = ValueLob.getFileName(dataHandler, valueLob.tableId, valueLob.objectId);
            this.copyFile(dataHandler, this.fileName, string);
            valueLob.fileName = string;
            valueLob.linked = true;
            return valueLob;
        }
        if (!this.linked) {
            this.tableId = n;
            String string = ValueLob.getFileName(dataHandler, this.tableId, this.objectId);
            if (this.tempFile != null) {
                this.tempFile.stopAutoDelete();
                this.tempFile = null;
            }
            ValueLob.renameFile(dataHandler, this.fileName, string);
            this.fileName = string;
            this.linked = true;
        }
        return this;
    }

    public int getTableId() {
        return this.tableId;
    }

    public int getObjectId() {
        return this.objectId;
    }

    public int getType() {
        return this.type;
    }

    public long getPrecision() {
        return this.precision;
    }

    public String getString() {
        int n = this.precision > Integer.MAX_VALUE || this.precision == 0L ? Integer.MAX_VALUE : (int)this.precision;
        try {
            if (this.type == 16) {
                if (this.small != null) {
                    return StringUtils.utf8Decode(this.small);
                }
                return IOUtils.readStringAndClose(this.getReader(), n);
            }
            byte[] byArray = this.small != null ? this.small : IOUtils.readBytesAndClose(this.getInputStream(), n);
            return ByteUtils.convertBytesToString(byArray);
        }
        catch (IOException iOException) {
            throw Message.convertToInternal(Message.convertIOException(iOException, this.fileName));
        }
        catch (SQLException sQLException) {
            throw Message.convertToInternal(sQLException);
        }
    }

    public byte[] getBytes() throws SQLException {
        if (this.type == 16) {
            return super.getBytes();
        }
        byte[] byArray = this.getBytesNoCopy();
        return ByteUtils.cloneByteArray(byArray);
    }

    public byte[] getBytesNoCopy() throws SQLException {
        if (this.type == 16) {
            return super.getBytesNoCopy();
        }
        if (this.small != null) {
            return this.small;
        }
        try {
            return IOUtils.readBytesAndClose(this.getInputStream(), Integer.MAX_VALUE);
        }
        catch (IOException iOException) {
            throw Message.convertIOException(iOException, this.fileName);
        }
    }

    public int hashCode() {
        if (this.hash == 0) {
            if (this.precision > 4096L) {
                return (int)(this.precision ^ this.precision >>> 32);
            }
            try {
                this.hash = this.type == 16 ? this.getString().hashCode() : ByteUtils.getByteArrayHash(this.getBytes());
            }
            catch (SQLException sQLException) {
                throw Message.convertToInternal(sQLException);
            }
        }
        return this.hash;
    }

    protected int compareSecure(Value value, CompareMode compareMode) throws SQLException {
        if (this.type == 16) {
            int n = this.getString().compareTo(value.getString());
            return n == 0 ? 0 : (n < 0 ? -1 : 1);
        }
        byte[] byArray = value.getBytesNoCopy();
        return ByteUtils.compareNotNull(this.getBytes(), byArray);
    }

    public Object getObject() {
        if (this.type == 16) {
            return this.getReader();
        }
        try {
            return this.getInputStream();
        }
        catch (SQLException sQLException) {
            throw Message.convertToInternal(sQLException);
        }
    }

    public Reader getReader() {
        try {
            return IOUtils.getReader(this.getInputStream());
        }
        catch (SQLException sQLException) {
            throw Message.convertToInternal(sQLException);
        }
    }

    public InputStream getInputStream() throws SQLException {
        if (this.fileName == null) {
            return new ByteArrayInputStream(this.small);
        }
        FileStore fileStore = this.handler.openFile(this.fileName, "r", true);
        boolean bl = SysProperties.lobCloseBetweenReads;
        return new BufferedInputStream(new FileStoreInputStream(fileStore, this.handler, this.compression, bl), 4096);
    }

    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        long l = this.getPrecision();
        if (l > Integer.MAX_VALUE || l <= 0L) {
            l = -1L;
        }
        if (this.type == 15) {
            preparedStatement.setBinaryStream(n, this.getInputStream(), (int)l);
        } else {
            preparedStatement.setCharacterStream(n, this.getReader(), (int)l);
        }
    }

    public String getSQL() {
        try {
            if (this.type == 16) {
                String string = this.getString();
                return StringUtils.quoteStringSQL(string);
            }
            byte[] byArray = this.getBytes();
            String string = ByteUtils.convertBytesToString(byArray);
            return "X'" + string + "'";
        }
        catch (SQLException sQLException) {
            throw Message.convertToInternal(sQLException);
        }
    }

    public String getTraceSQL() {
        if (this.small != null && this.getPrecision() <= SysProperties.MAX_TRACE_DATA_LENGTH) {
            return this.getSQL();
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (this.type == 16) {
            stringBuilder.append("SPACE(").append(this.getPrecision());
        } else {
            stringBuilder.append("CAST(REPEAT('00', ").append(this.getPrecision()).append(") AS BINARY");
        }
        stringBuilder.append(" /* ").append(this.fileName).append(" */)");
        return stringBuilder.toString();
    }

    public byte[] getSmall() {
        return this.small;
    }

    public int getDisplaySize() {
        return MathUtils.convertLongToInt(this.getPrecision());
    }

    public boolean equals(Object object) {
        try {
            return object instanceof ValueLob && this.compareSecure((Value)object, null) == 0;
        }
        catch (SQLException sQLException) {
            throw Message.convertToInternal(sQLException);
        }
    }

    public void convertToFileIfRequired(DataHandler dataHandler) throws SQLException {
        if (this.small != null && this.small.length > dataHandler.getMaxLengthInplaceLob()) {
            boolean bl = dataHandler.getLobCompressionAlgorithm(this.type) != null;
            int n = ValueLob.getBufferSize(dataHandler, bl, Long.MAX_VALUE);
            int n2 = this.tableId;
            if (this.type == 15) {
                this.createFromStream(ByteUtils.newBytes(n), 0, this.getInputStream(), Long.MAX_VALUE, dataHandler);
            } else {
                this.createFromReader(new char[n], 0, this.getReader(), Long.MAX_VALUE, dataHandler);
            }
            Value value = this.link(dataHandler, n2);
            if (SysProperties.CHECK && value != this) {
                Message.throwInternalError();
            }
        }
    }

    public static void removeAllForTable(DataHandler dataHandler, int n) throws SQLException {
        if (dataHandler.getLobFilesInDirectories()) {
            String string = ValueLob.getFileNamePrefix(dataHandler.getDatabasePath(), 0);
            ValueLob.removeAllForTable(dataHandler, string, n);
        } else {
            String[] stringArray;
            String string = dataHandler.getDatabasePath();
            String string2 = FileUtils.getParent(string);
            for (String string3 : stringArray = FileUtils.listFiles(string2)) {
                if (!string3.startsWith(string + "." + n + ".") || !string3.endsWith(".lob.db")) continue;
                ValueLob.deleteFile(dataHandler, string3);
            }
        }
    }

    public static boolean existsLobFile(String string) throws SQLException {
        String[] stringArray;
        String string2 = FileUtils.getParent(string);
        for (String string3 : stringArray = FileUtils.listFiles(string2)) {
            if (!string3.startsWith(string + ".") || !string3.endsWith(".lob.db")) continue;
            return true;
        }
        return false;
    }

    private static void removeAllForTable(DataHandler dataHandler, String string, int n) throws SQLException {
        for (String string2 : FileUtils.listFiles(string)) {
            if (FileUtils.isDirectory(string2)) {
                ValueLob.removeAllForTable(dataHandler, string2, n);
                continue;
            }
            if (!string2.endsWith(".t" + n + ".lob.db")) continue;
            ValueLob.deleteFile(dataHandler, string2);
        }
    }

    public boolean useCompression() {
        return this.compression;
    }

    public boolean isFileBased() {
        return this.fileName != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void deleteFile(DataHandler dataHandler, String string) throws SQLException {
        Object object = dataHandler.getLobSyncObject();
        synchronized (object) {
            FileUtils.delete(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void renameFile(DataHandler dataHandler, String string, String string2) throws SQLException {
        Object object = dataHandler.getLobSyncObject();
        synchronized (object) {
            FileUtils.rename(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(DataHandler dataHandler, String string, String string2) throws SQLException {
        Object object = dataHandler.getLobSyncObject();
        synchronized (object) {
            FileSystem.getInstance(string).copy(string, string2);
        }
    }

    public void setFileName(String string, boolean bl) {
        this.fileName = string;
        this.linked = bl;
    }

    public int getMemory() {
        if (this.small != null) {
            return this.small.length + 32;
        }
        return 128;
    }
}

