/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.dbsync;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.DbGenerator;
import org.apache.cayenne.access.dbsync.BaseSchemaUpdateStrategy;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateIfNoSchemaStrategy
extends BaseSchemaUpdateStrategy {
    static final Log logger = LogFactory.getLog(CreateIfNoSchemaStrategy.class);

    @Override
    public void processSchemaUpdate(DataNode dataNode) throws SQLException {
        Map<String, Boolean> nameTables = this.getNameTablesInDB(dataNode);
        Collection<DbEntity> entities = dataNode.getEntityResolver().getDbEntities();
        boolean generate = true;
        Iterator<DbEntity> it = entities.iterator();
        while (it.hasNext()) {
            if (nameTables.get(it.next().getName()) == null) continue;
            generate = false;
            break;
        }
        if (generate) {
            logger.info((Object)"No schema detected, will create mapped tables");
            this.generate(dataNode);
        } else {
            logger.info((Object)"Full or partial schema detected, skipping tables creation");
        }
    }

    private void generate(DataNode dataNode) {
        Collection<DataMap> map = dataNode.getDataMaps();
        Iterator<DataMap> iterator = map.iterator();
        while (iterator.hasNext()) {
            DbGenerator gen = new DbGenerator(dataNode.getAdapter(), iterator.next());
            gen.setShouldCreateTables(true);
            gen.setShouldDropTables(false);
            gen.setShouldCreateFKConstraints(false);
            gen.setShouldCreatePKSupport(false);
            gen.setShouldDropPKSupport(false);
            try {
                gen.runGenerator(dataNode.getDataSource());
            }
            catch (Exception e) {
                throw new CayenneRuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, Boolean> getNameTablesInDB(DataNode dataNode) throws SQLException {
        String tableLabel = dataNode.getAdapter().tableTypeForTable();
        Connection con = null;
        HashMap<String, Boolean> nameTables = new HashMap<String, Boolean>();
        con = dataNode.getDataSource().getConnection();
        try {
            ResultSet rs = con.getMetaData().getTables(null, null, "%", new String[]{tableLabel});
            try {
                while (rs.next()) {
                    String name = rs.getString("TABLE_NAME");
                    nameTables.put(name, false);
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            con.close();
        }
        return nameTables;
    }
}

