/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.jdbc.ColumnDescriptor;
import org.apache.cayenne.access.jdbc.RowDescriptor;
import org.apache.cayenne.access.types.ExtendedType;
import org.apache.cayenne.access.types.ExtendedTypeMap;
import org.apache.commons.collections.Transformer;

public class RowDescriptorBuilder {
    private static final Transformer UPPERCASE_TRANSFORMER = new Transformer(){

        public Object transform(Object input) {
            return input != null ? input.toString().toUpperCase() : null;
        }
    };
    private static final Transformer LOWERCASE_TRANSFORMER = new Transformer(){

        public Object transform(Object input) {
            return input != null ? input.toString().toLowerCase() : null;
        }
    };
    protected ColumnDescriptor[] columns;
    protected ResultSetMetaData resultSetMetadata;
    protected Transformer caseTransformer;
    protected Map<String, String> typeOverrides;

    public RowDescriptor getDescriptor(ExtendedTypeMap typeMap) throws SQLException, IllegalStateException {
        ColumnDescriptor[] columns;
        if (this.columns != null) {
            columns = this.columnsFromPresetColumns();
        } else if (this.resultSetMetadata != null) {
            columns = this.columnsFromResultSet();
        } else {
            throw new IllegalStateException("Can't build RowDescriptor, both 'columns' and 'resultSetMetadata' are null");
        }
        ExtendedType[] converters = new ExtendedType[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            converters[i] = typeMap.getRegisteredType(columns[i].getJavaClass());
        }
        return new RowDescriptor(columns, converters);
    }

    protected ColumnDescriptor[] columnsFromPresetColumns() {
        int i;
        int len = this.columns.length;
        if (this.caseTransformer != null) {
            for (i = 0; i < len; ++i) {
                String oldLabel = this.columns[i].getDataRowKey();
                String oldName = this.columns[i].getName();
                String newLabel = (String)this.caseTransformer.transform((Object)oldLabel);
                this.columns[i].setDataRowKey(newLabel);
                if (!oldName.equals(oldLabel)) continue;
                this.columns[i].setName(newLabel);
            }
        }
        if (this.typeOverrides != null) {
            for (i = 0; i < len; ++i) {
                String type = this.typeOverrides.get(this.columns[i].getName());
                if (type == null) continue;
                this.columns[i].setJavaClass(type);
            }
        }
        return this.columns;
    }

    protected ColumnDescriptor[] columnsFromResultSet() throws SQLException {
        int len = this.resultSetMetadata.getColumnCount();
        if (len == 0) {
            throw new CayenneRuntimeException("No columns in ResultSet.");
        }
        ColumnDescriptor[] columns = new ColumnDescriptor[len];
        for (int i = 0; i < len; ++i) {
            int position = i + 1;
            String name = this.resultSetMetadata.getColumnLabel(position);
            if (!(name != null && name.length() != 0 || (name = this.resultSetMetadata.getColumnName(position)) != null && name.length() != 0)) {
                name = "column_" + position;
            }
            if (this.caseTransformer != null) {
                name = (String)this.caseTransformer.transform((Object)name);
            }
            int jdbcType = this.resultSetMetadata.getColumnType(position);
            String javaClass = null;
            if (this.typeOverrides != null) {
                javaClass = this.typeOverrides.get(name);
            }
            if (javaClass == null) {
                javaClass = this.resultSetMetadata.getColumnClassName(position);
            }
            columns[i] = new ColumnDescriptor(name, jdbcType, javaClass);
        }
        return columns;
    }

    public RowDescriptorBuilder setColumns(ColumnDescriptor[] columns) {
        this.columns = columns;
        return this;
    }

    public RowDescriptorBuilder setResultSet(ResultSet resultSet) throws SQLException {
        this.resultSetMetadata = resultSet.getMetaData();
        return this;
    }

    public RowDescriptorBuilder useLowercaseColumnNames() {
        this.caseTransformer = LOWERCASE_TRANSFORMER;
        return this;
    }

    public RowDescriptorBuilder useUppercaseColumnNames() {
        this.caseTransformer = UPPERCASE_TRANSFORMER;
        return this;
    }

    public RowDescriptorBuilder overrideColumnType(String columnName, String type) {
        if (this.typeOverrides == null) {
            this.typeOverrides = new HashMap<String, String>();
        }
        this.typeOverrides.put(columnName, type);
        return this;
    }

    public boolean isOverriden(String columnName) {
        return this.typeOverrides != null && this.typeOverrides.containsKey(columnName);
    }
}

