/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.hsqldb;

import java.util.Collections;
import java.util.List;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.QuotingStrategy;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;
import org.apache.cayenne.merge.SetAllowNullToDb;
import org.apache.cayenne.merge.SetColumnTypeToDb;

public class HSQLMergerFactory
extends MergerFactory {
    public MergerToken createSetColumnTypeToDb(final DbEntity entity, DbAttribute columnOriginal, final DbAttribute columnNew) {
        return new SetColumnTypeToDb(entity, columnOriginal, columnNew){

            protected void appendPrefix(StringBuffer sqlBuffer, QuotingStrategy context) {
                sqlBuffer.append("ALTER TABLE ");
                sqlBuffer.append(context.quoteFullyQualifiedName(entity));
                sqlBuffer.append(" ALTER ");
                sqlBuffer.append(context.quoteString(columnNew.getName()));
                sqlBuffer.append(" ");
            }
        };
    }

    public MergerToken createSetAllowNullToDb(DbEntity entity, DbAttribute column) {
        return new SetAllowNullToDb(entity, column){

            @Override
            public List<String> createSql(DbAdapter adapter) {
                StringBuilder sqlBuffer = new StringBuilder();
                QuotingStrategy context = adapter.getQuotingStrategy(this.getEntity().getDataMap().isQuotingSQLIdentifiers());
                sqlBuffer.append("ALTER TABLE ");
                sqlBuffer.append(context.quoteFullyQualifiedName(this.getEntity()));
                sqlBuffer.append(" ALTER COLUMN ");
                sqlBuffer.append(context.quoteString(this.getColumn().getName()));
                sqlBuffer.append(" NULL");
                return Collections.singletonList(sqlBuffer.toString());
            }
        };
    }
}

