/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba.oracle;

import java.io.OutputStream;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.CayenneException;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.access.QueryLogger;
import org.apache.cayenne.access.trans.LOBBatchQueryBuilder;
import org.apache.cayenne.access.trans.LOBBatchQueryWrapper;
import org.apache.cayenne.access.trans.LOBInsertBatchQueryBuilder;
import org.apache.cayenne.access.trans.LOBUpdateBatchQueryBuilder;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.query.BatchQuery;
import org.apache.cayenne.query.InsertBatchQuery;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.UpdateBatchQuery;
import org.apache.cayenne.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class OracleLOBBatchAction
implements SQLAction {
    BatchQuery query;
    DbAdapter adapter;

    OracleLOBBatchAction(BatchQuery query, DbAdapter adapter) {
        this.adapter = adapter;
        this.query = query;
    }

    DbAdapter getAdapter() {
        return this.adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performAction(Connection connection, OperationObserver observer) throws SQLException, Exception {
        LOBBatchQueryBuilder queryBuilder;
        if (this.query instanceof InsertBatchQuery) {
            queryBuilder = new LOBInsertBatchQueryBuilder(this.getAdapter());
        } else if (this.query instanceof UpdateBatchQuery) {
            queryBuilder = new LOBUpdateBatchQueryBuilder(this.getAdapter());
        } else {
            throw new CayenneException("Unsupported batch type for special LOB processing: " + this.query);
        }
        queryBuilder.setTrimFunction("RTRIM");
        queryBuilder.setNewBlobFunction("EMPTY_BLOB()");
        queryBuilder.setNewClobFunction("EMPTY_CLOB()");
        LOBBatchQueryWrapper selectQuery = new LOBBatchQueryWrapper(this.query);
        List<DbAttribute> qualifierAttributes = selectQuery.getDbAttributesForLOBSelectQualifier();
        boolean isLoggable = QueryLogger.isLoggable();
        this.query.reset();
        while (selectQuery.next()) {
            int updated = 0;
            String updateStr = queryBuilder.createSqlString(this.query);
            QueryLogger.logQuery(updateStr, Collections.EMPTY_LIST);
            PreparedStatement statement = connection.prepareStatement(updateStr);
            try {
                if (isLoggable) {
                    List bindings = queryBuilder.getValuesForLOBUpdateParameters(this.query);
                    QueryLogger.logQueryParameters("bind", null, bindings, this.query instanceof InsertBatchQuery);
                }
                queryBuilder.bindParameters(statement, this.query);
                updated = statement.executeUpdate();
                QueryLogger.logUpdateCount(updated);
            }
            finally {
                try {
                    statement.close();
                }
                catch (Exception e) {}
            }
            this.processLOBRow(connection, queryBuilder, selectQuery, qualifierAttributes);
            observer.nextCount(this.query, updated);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processLOBRow(Connection con, LOBBatchQueryBuilder queryBuilder, LOBBatchQueryWrapper selectQuery, List<DbAttribute> qualifierAttributes) throws SQLException, Exception {
        List<DbAttribute> lobAttributes = selectQuery.getDbAttributesForUpdatedLOBColumns();
        if (lobAttributes.size() == 0) {
            return;
        }
        boolean isLoggable = QueryLogger.isLoggable();
        List qualifierValues = selectQuery.getValuesForLOBSelectQualifier();
        List lobValues = selectQuery.getValuesForUpdatedLOBColumns();
        int parametersSize = qualifierValues.size();
        int lobSize = lobAttributes.size();
        String selectStr = queryBuilder.createLOBSelectString(selectQuery.getQuery(), lobAttributes, qualifierAttributes);
        if (isLoggable) {
            QueryLogger.logQuery(selectStr, qualifierValues);
            QueryLogger.logQueryParameters("write LOB", null, lobValues, false);
        }
        PreparedStatement selectStatement = con.prepareStatement(selectStr);
        try {
            DbAttribute attribute;
            for (int i = 0; i < parametersSize; ++i) {
                Object value = qualifierValues.get(i);
                attribute = qualifierAttributes.get(i);
                this.adapter.bindParameter(selectStatement, value, i + 1, attribute.getType(), attribute.getScale());
            }
            ResultSet result = selectStatement.executeQuery();
            try {
                if (!result.next()) {
                    throw new CayenneRuntimeException("Missing LOB row.");
                }
                for (int i = 0; i < lobSize; ++i) {
                    attribute = lobAttributes.get(i);
                    int type = attribute.getType();
                    if (type == 2005) {
                        Clob clob = result.getClob(i + 1);
                        Object clobVal = lobValues.get(i);
                        if (clobVal instanceof char[]) {
                            this.writeClob(clob, (char[])clobVal);
                            continue;
                        }
                        this.writeClob(clob, clobVal.toString());
                        continue;
                    }
                    if (type == 2004) {
                        Blob blob = result.getBlob(i + 1);
                        Object blobVal = lobValues.get(i);
                        if (blobVal instanceof byte[]) {
                            this.writeBlob(blob, (byte[])blobVal);
                            continue;
                        }
                        String className = blobVal != null ? blobVal.getClass().getName() : null;
                        throw new CayenneRuntimeException("Unsupported class of BLOB value: " + className);
                    }
                    throw new CayenneRuntimeException("Only BLOB or CLOB is expected here, got: " + type);
                }
                if (result.next()) {
                    throw new CayenneRuntimeException("More than one LOB row found.");
                }
            }
            finally {
                try {
                    result.close();
                }
                catch (Exception e) {}
            }
        }
        finally {
            try {
                selectStatement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBlob(Blob blob, byte[] value) {
        try {
            OutputStream out = blob.setBinaryStream(0L);
            try {
                out.write(value);
                out.flush();
            }
            finally {
                out.close();
            }
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("Error processing BLOB.", Util.unwindException(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeClob(Clob clob, char[] value) {
        try {
            Writer out = clob.setCharacterStream(0L);
            try {
                out.write(value);
                out.flush();
            }
            finally {
                out.close();
            }
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("Error processing CLOB.", Util.unwindException(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeClob(Clob clob, String value) {
        try {
            Writer out = clob.setCharacterStream(0L);
            try {
                out.write(value);
                out.flush();
            }
            finally {
                out.close();
            }
        }
        catch (Exception e) {
            throw new CayenneRuntimeException("Error processing CLOB.", Util.unwindException(e));
        }
    }
}

