/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.merge;

import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.ObjEntity;
import org.apache.cayenne.merge.AbstractToModelToken;
import org.apache.cayenne.merge.MergerContext;
import org.apache.cayenne.merge.MergerFactory;
import org.apache.cayenne.merge.MergerToken;
import org.apache.cayenne.util.NameConverter;
import org.apache.cayenne.util.Util;

public class CreateTableToModel
extends AbstractToModelToken.Entity {
    private String objEntityClassName = null;

    public CreateTableToModel(DbEntity entity) {
        super(entity);
    }

    public void setObjEntityClassName(String n) {
        this.objEntityClassName = n;
    }

    public void execute(MergerContext mergerContext) {
        String objEntityName;
        DataMap map = mergerContext.getDataMap();
        map.addDbEntity(this.getEntity());
        String baseName = objEntityName = NameConverter.underscoredToJava(this.getEntity().getName(), true);
        for (int i = 1; i < 1000 && map.getObjEntity(objEntityName) != null; ++i) {
            objEntityName = baseName + i;
        }
        ObjEntity objEntity = new ObjEntity(objEntityName);
        objEntity.setDbEntity(this.getEntity());
        String className = this.objEntityClassName;
        if (className == null) {
            String packageName = map.getDefaultPackage();
            if (Util.isEmptyString(packageName)) {
                packageName = "";
            } else if (!packageName.endsWith(".")) {
                packageName = packageName + ".";
            }
            className = packageName + objEntityName;
        }
        objEntity.setClassName(className);
        objEntity.setSuperClassName(map.getDefaultSuperclass());
        if (map.isClientSupported()) {
            String clientPkg = map.getDefaultClientPackage();
            if (clientPkg != null) {
                if (!clientPkg.endsWith(".")) {
                    clientPkg = clientPkg + ".";
                }
                objEntity.setClientClassName(clientPkg + objEntity.getName());
            }
            objEntity.setClientSuperClassName(map.getDefaultClientSuperclass());
        }
        map.addObjEntity(objEntity);
        this.synchronizeWithObjEntity(this.getEntity());
    }

    public String getTokenName() {
        return "Create Table";
    }

    public MergerToken createReverse(MergerFactory factory) {
        return factory.createDropTableToDb(this.getEntity());
    }
}

