/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.query;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.ejbql.EJBQLCompiledExpression;
import org.apache.cayenne.ejbql.EJBQLException;
import org.apache.cayenne.ejbql.EJBQLParserFactory;
import org.apache.cayenne.map.DataMap;
import org.apache.cayenne.map.EntityResolver;
import org.apache.cayenne.query.EJBQLQueryMetadata;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.QueryCacheStrategy;
import org.apache.cayenne.query.QueryMetadata;
import org.apache.cayenne.query.QueryRouter;
import org.apache.cayenne.query.SQLAction;
import org.apache.cayenne.query.SQLActionVisitor;
import org.apache.cayenne.util.XMLEncoder;
import org.apache.cayenne.util.XMLSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBQLQuery
implements Query,
XMLSerializable {
    protected String name;
    protected String ejbqlStatement;
    protected Map<String, Object> namedParameters;
    protected Map<Integer, Object> positionalParameters;
    protected transient EJBQLCompiledExpression expression;
    EJBQLQueryMetadata metadata = new EJBQLQueryMetadata();

    public EJBQLQuery(String ejbqlStatement) {
        this.ejbqlStatement = ejbqlStatement;
    }

    public EJBQLQuery() {
    }

    public void initWithProperties(Map<String, ?> properties) {
        if (properties == null) {
            properties = Collections.EMPTY_MAP;
        }
        this.metadata.initWithProperties(properties);
    }

    @Override
    public QueryMetadata getMetaData(EntityResolver resolver) {
        this.metadata.resolve(resolver, this);
        return this.metadata;
    }

    public boolean isFetchingDataRows() {
        return this.metadata.isFetchingDataRows();
    }

    public void setFetchingDataRows(boolean flag) {
        this.metadata.setFetchingDataRows(flag);
    }

    public String[] getCacheGroups() {
        return this.metadata.getCacheGroups();
    }

    public QueryCacheStrategy getCacheStrategy() {
        return this.metadata.getCacheStrategy();
    }

    public void setCacheGroups(String ... cacheGroups) {
        this.metadata.setCacheGroups(cacheGroups);
    }

    public void setCacheStrategy(QueryCacheStrategy strategy) {
        this.metadata.setCacheStrategy(strategy);
    }

    @Override
    public void route(QueryRouter router, EntityResolver resolver, Query substitutedQuery) {
        DataMap map = this.getMetaData(resolver).getDataMap();
        if (map == null) {
            throw new CayenneRuntimeException("No DataMap found, can't route query " + this);
        }
        router.route(router.engineForDataMap(map), this, substitutedQuery);
    }

    @Override
    public SQLAction createSQLAction(SQLActionVisitor visitor) {
        return visitor.ejbqlAction(this);
    }

    public String getEjbqlStatement() {
        return this.ejbqlStatement;
    }

    public EJBQLCompiledExpression getExpression(EntityResolver resolver) throws EJBQLException {
        if (this.expression == null) {
            this.expression = EJBQLParserFactory.getParser().compile(this.ejbqlStatement, resolver);
        }
        return this.expression;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map<String, Object> getNamedParameters() {
        return this.namedParameters != null ? Collections.unmodifiableMap(this.namedParameters) : Collections.EMPTY_MAP;
    }

    public Map<Integer, Object> getPositionalParameters() {
        return this.positionalParameters != null ? Collections.unmodifiableMap(this.positionalParameters) : Collections.EMPTY_MAP;
    }

    public void setParameter(String name, Object object) {
        if (name == null || name.length() < 1) {
            throw new IllegalArgumentException("Null or empty parameter name");
        }
        if (this.namedParameters == null) {
            this.namedParameters = new HashMap<String, Object>();
        }
        this.namedParameters.put(name, object);
    }

    public void setParameter(int position, Object object) {
        if (position < 1) {
            throw new IllegalArgumentException("Parameter position must be >= 1: " + position);
        }
        if (this.positionalParameters == null) {
            this.positionalParameters = new HashMap<Integer, Object>();
        }
        this.positionalParameters.put(position, object);
    }

    public int getFetchLimit() {
        return this.metadata.getFetchLimit();
    }

    public void setFetchLimit(int fetchLimit) {
        this.metadata.setFetchLimit(fetchLimit);
    }

    public int getFetchOffset() {
        return this.metadata.getFetchOffset();
    }

    public void setFetchOffset(int fetchOffset) {
        this.metadata.setFetchOffset(fetchOffset);
    }

    @Override
    public void encodeAsXML(XMLEncoder encoder) {
        encoder.print("<query name=\"");
        encoder.print(this.getName());
        encoder.print("\" factory=\"");
        encoder.print("org.apache.cayenne.map.EjbqlBuilder");
        encoder.println("\">");
        encoder.indent(1);
        this.metadata.encodeAsXML(encoder);
        if (this.ejbqlStatement != null) {
            encoder.print("<ejbql><![CDATA[");
            encoder.print(this.ejbqlStatement);
            encoder.println("]]></ejbql>");
        }
        encoder.indent(-1);
        encoder.println("</query>");
    }

    public void setEjbqlStatement(String text) {
        this.ejbqlStatement = text;
    }

    public int getPageSize() {
        return this.metadata.getPageSize();
    }

    public void setPageSize(int pageSize) {
        this.metadata.setPageSize(pageSize);
    }
}

