/**
 * This file is distributed under the GPL
 * $Id: CommandInvite.java 1828 2009-06-26 18:38:50Z scotta $
 */
package net.bnubot.bot.commands;

import net.bnubot.core.CommandResponseCookie;
import net.bnubot.core.Connection;
import net.bnubot.core.commands.CommandRunnable;
import net.bnubot.db.Account;
import net.bnubot.util.BNetUser;

/**
 * @author scotta
 */
public final class CommandInvite implements CommandRunnable {
	public void run(Connection source, BNetUser user, String param, String[] params, boolean whisperBack, Account commanderAccount, boolean superUser)
	throws Exception {
		if((params == null) || (params.length != 1))
			user.sendChat("Use: %trigger%invite <user>", whisperBack);
		else
			source.sendClanInvitation(new CommandResponseCookie(user, whisperBack), params[0]);
	}
}