/**
 * This file is distributed under the GPL
 * $Id: GhostDefaultTextField.java 1803 2009-06-19 20:32:47Z scotta $
 */
package net.bnubot.bot.gui.components;

import java.awt.Color;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;


/**
 * @author scotta
 */
public class GhostDefaultTextField extends ConfigTextField implements MouseListener, FocusListener {
	private static final long serialVersionUID = 5908386893553368742L;

	private static final Color ghostColor = Color.GRAY;

	private final Color defaultColor;
	private final String defaultText;

	private boolean ghosted = false;

	/**
	 * @param defaultText
	 */
	public GhostDefaultTextField(String defaultText) {
		super(defaultText);
		this.defaultText = defaultText;
		this.defaultColor = getForeground();
		addMouseListener(this);
		addFocusListener(this);

		setGhosted(true);
	}

	public void reset() {
		setGhosted(true);
	}

	public boolean isGhosted() {
		if((getText() == null) || (getText().length() == 0))
			return true;
		return ghosted;
	}

	private void setGhosted(boolean ghosted) {
		if(ghosted != this.ghosted) {
			this.ghosted = ghosted;
			if(ghosted) {
				setForeground(ghostColor);
				super.setText(defaultText);
			} else {
				setForeground(defaultColor);
				super.setText(null);
			}
		}
	}

	public void focusGained(FocusEvent e) {
		setGhosted(false);
	}
	public void focusLost(FocusEvent e) {
		if((getText() == null) || (getText().length() == 0))
			reset();
	}

	@Override
	public void setText(String t) {
		setGhosted(false);
		super.setText(t);
	}

	public void mouseClicked(MouseEvent e) {
		if(!ghosted)
			return;
		setText(null);
		requestFocus();
	}
	public void mouseEntered(MouseEvent e) {}
	public void mouseExited(MouseEvent e) {}
	public void mousePressed(MouseEvent e) {}
	public void mouseReleased(MouseEvent e) {}


}
