/**
 * This file is distributed under the GPL
 * $Id: CustomDataObject.java 1715 2009-03-25 17:20:27Z scotta $
 */

package net.bnubot.db;

import org.apache.cayenne.CayenneDataObject;
import org.apache.cayenne.DataObjectUtils;

/**
 * @author scotta
 */
@SuppressWarnings("serial")
public abstract class CustomDataObject extends CayenneDataObject implements Comparable<CustomDataObject> {
	/**
	 * Try to save changes to this object
	 * @throws Exception If a commit error occurs
	 */
	public void updateRow() throws Exception {
		try {
			getObjectContext().commitChanges();
		} catch(Exception e) {
			getObjectContext().rollbackChanges();
			throw e;
		}
	}

	@SuppressWarnings("unchecked")
	public Comparable toSortField() {
		return Integer.valueOf(DataObjectUtils.intPKForObject(this));
	}

	public final String toDisplayString() {
		return toSortField().toString();
	}

	@Override
	public String toString() {
		return toDisplayString();
	}

	@SuppressWarnings("unchecked")
	public final int compareTo(CustomDataObject o) {
		return toSortField().compareTo(o.toSortField());
	}
}
