/**
 * This file is distributed under the GPL
 * $Id: _Account.java 1627 2008-09-23 16:57:14Z scotta $
 */

package net.bnubot.db.auto;

import java.util.Date;
import java.util.List;

import net.bnubot.db.Account;
import net.bnubot.db.BNLogin;
import net.bnubot.db.CustomDataObject;
import net.bnubot.db.Mail;
import net.bnubot.db.Rank;

/**
 * Class _Account was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 * @author cayenne-generated-file
 */
@SuppressWarnings("serial")
public abstract class _Account extends CustomDataObject {

    public static final String BIRTHDAY_PROPERTY = "birthday";
    public static final String CREATED_PROPERTY = "created";
    public static final String LAST_RANK_CHANGE_PROPERTY = "lastRankChange";
    public static final String NAME_PROPERTY = "name";
    public static final String TRIVIA_CORRECT_PROPERTY = "triviaCorrect";
    public static final String TRIVIA_WIN_PROPERTY = "triviaWin";
    public static final String FLAG_SPOOF_PROPERTY = "flagSpoof";
    public static final String BN_LOGINS_PROPERTY = "bnLogins";
    public static final String RANK_PROPERTY = "rank";
    public static final String RECIEVED_MAIL_PROPERTY = "recievedMail";
    public static final String RECRUITER_PROPERTY = "recruiter";
    public static final String RECRUITS_PROPERTY = "recruits";
    public static final String SENT_MAIL_PROPERTY = "sentMail";

    public static final String ID_PK_COLUMN = "id";

    public void setBirthday(Date birthday) {
        writeProperty(BIRTHDAY_PROPERTY, birthday);
    }
    public Date getBirthday() {
        return (Date)readProperty(BIRTHDAY_PROPERTY);
    }

    public void setCreated(Date created) {
        writeProperty(CREATED_PROPERTY, created);
    }
    public Date getCreated() {
        return (Date)readProperty(CREATED_PROPERTY);
    }

    public void setLastRankChange(Date lastRankChange) {
        writeProperty(LAST_RANK_CHANGE_PROPERTY, lastRankChange);
    }
    public Date getLastRankChange() {
        return (Date)readProperty(LAST_RANK_CHANGE_PROPERTY);
    }

    public void setName(String name) {
        writeProperty(NAME_PROPERTY, name);
    }
    public String getName() {
        return (String)readProperty(NAME_PROPERTY);
    }

    public void setTriviaCorrect(int triviaCorrect) {
        writeProperty(TRIVIA_CORRECT_PROPERTY, triviaCorrect);
    }
    public int getTriviaCorrect() {
        Object value = readProperty(TRIVIA_CORRECT_PROPERTY);
        return (value != null) ? (Integer) value : 0;
    }

    public void setTriviaWin(int triviaWin) {
        writeProperty(TRIVIA_WIN_PROPERTY, triviaWin);
    }
    public int getTriviaWin() {
        Object value = readProperty(TRIVIA_WIN_PROPERTY);
        return (value != null) ? (Integer) value : 0;
    }

    public void setFlagSpoof(int flagSpoof) {
        writeProperty(FLAG_SPOOF_PROPERTY, flagSpoof);
    }
    public int getFlagSpoof() {
        Object value = readProperty(FLAG_SPOOF_PROPERTY);
        return (value != null) ? (Integer) value : 0;
    }

    public void addToBnLogins(BNLogin obj) {
        addToManyTarget(BN_LOGINS_PROPERTY, obj, true);
    }
    public void removeFromBnLogins(BNLogin obj) {
        removeToManyTarget(BN_LOGINS_PROPERTY, obj, true);
    }
    @SuppressWarnings("unchecked")
    public List<BNLogin> getBnLogins() {
        return (List<BNLogin>)readProperty(BN_LOGINS_PROPERTY);
    }

    public void setRank(Rank rank) {
        setToOneTarget(RANK_PROPERTY, rank, true);
    }
    public Rank getRank() {
        return (Rank)readProperty(RANK_PROPERTY);
    }

    public void addToRecievedMail(Mail obj) {
        addToManyTarget(RECIEVED_MAIL_PROPERTY, obj, true);
    }
    public void removeFromRecievedMail(Mail obj) {
        removeToManyTarget(RECIEVED_MAIL_PROPERTY, obj, true);
    }
    @SuppressWarnings("unchecked")
    public List<Mail> getRecievedMail() {
        return (List<Mail>)readProperty(RECIEVED_MAIL_PROPERTY);
    }

    public void setRecruiter(Account recruiter) {
        setToOneTarget(RECRUITER_PROPERTY, recruiter, true);
    }
    public Account getRecruiter() {
        return (Account)readProperty(RECRUITER_PROPERTY);
    }

    public void addToRecruits(Account obj) {
        addToManyTarget(RECRUITS_PROPERTY, obj, true);
    }
    public void removeFromRecruits(Account obj) {
        removeToManyTarget(RECRUITS_PROPERTY, obj, true);
    }
    @SuppressWarnings("unchecked")
    public List<Account> getRecruits() {
        return (List<Account>)readProperty(RECRUITS_PROPERTY);
    }

    public void addToSentMail(Mail obj) {
        addToManyTarget(SENT_MAIL_PROPERTY, obj, true);
    }
    public void removeFromSentMail(Mail obj) {
        removeToManyTarget(SENT_MAIL_PROPERTY, obj, true);
    }
    @SuppressWarnings("unchecked")
    public List<Mail> getSentMail() {
        return (List<Mail>)readProperty(SENT_MAIL_PROPERTY);
    }

}
