/*  Similar to Blizzard's GreetBot code; reworked  *
 *  for Linux/Unix.  See the README file.          *
 *              Will Lorentz, wlorentz@san.rr.com  */
 
#include "bot.h"


int main()
{
  initialise();

  SetLogonInfo("Guest", "guest", "exodus.battle.net");
  SetHomeChannel("The Void");

  while ( 1 ) {
    if ( !Reconnect() ) break;
    MsgLoop();
    Disconnect();
  }

  return 0;
}


void initialise()
{
  s = INVALID_SOCKET;
  nServerPort = 6112;
  szLoginName[0] = '\0';
  szUniqueName[0] = '\0';
  szPassword[0] = '\0';
  szServerAddr[0] = '\0';
  szHomeChannel[0] = '\0';
  szCurrentChannel[0] = '\0';
}


void SetLogonInfo(char *szUserName,
                         char *szUserPass,
                         char *szServer)
{
  strcpy(szLoginName, szUserName);
  strcpy(szUniqueName, szUserName);
  strcpy(szPassword, szUserPass);
  strcpy(szServerAddr, szServer);
  nServerPort = BNET_PORT;
}


void SetHomeChannel(char *szChannelName)
{  
  strcpy(szHomeChannel, szChannelName);
}


int Connect() {
  struct sockaddr_in name;
  struct hostent *hp;
  char *p;
  
  memset(&name, '\0', sizeof(name));
  name.sin_family = AF_INET;
  name.sin_port = htons(nServerPort);

  /* if this is a hostname and not an IP address, resolve it */
  p = szServerAddr;
  while (*p && (isdigit(*p) || (*p == '.'))) {
    p++;
  }

  /* non-digit found - assume hostname */
  if (*p) {
    hp = ( struct hostent * )gethostbyname(szServerAddr);
    if ( hp == 0 )
      return 0;         /* can't resolve hostname */
    memcpy(&name.sin_addr, hp->h_addr, hp->h_length);
  }
  else {
    name.sin_addr.s_addr = inet_addr(szServerAddr);
  }

  s = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
  if (s == INVALID_SOCKET) {
    return 0;
  }

  if (connect(s, (struct sockaddr *)&name, sizeof(name))) {
    return 0;
  }

  return 1;
}


int Logon()
{ 
  /* send ^C, ^D, username, and password
     ^C gets the server's attention for logon; ^D turns off ECHO */
  Send("%c%c%s\r\n%s\r\n", 0x03, 0x04, szLoginName, szPassword);

  return 1;
}


void Disconnect()
{  
  if (s == INVALID_SOCKET) return;
  shutdown( s, 0 );
  s = INVALID_SOCKET;
}


int Reconnect() {
  int tries;
  
  for ( tries=0; tries < 10; ++tries ) {
    if (!Connect()) {
      sleep(5);
      continue;
    }
    if (!Logon()) {
      continue;
    }
    return 1;
  }
  return 0;
}


int Send(char *lpszFmt, ...) {
  char szOutStr[MAXTEXTLENGTH];
  va_list argptr;
  
  va_start(argptr, lpszFmt);
  vsprintf(szOutStr, lpszFmt, argptr);
  va_end(argptr);

  if (send(s, szOutStr, strlen(szOutStr), 0) < 0)
    return 0;

  return 1;
}


int ParseEvent(char *pszEvent, int *pnEventId, char *pszSpeaker, u_long *puFlags, char *pszEventText)
{
  char *p;

  if (!pszEvent || !pnEventId || !pszSpeaker || !puFlags || !pszEventText)
    return 1;

  *pszSpeaker = '\0';
  *pszEventText = '\0';
  *puFlags = 0;

  *pnEventId = atoi(pszEvent);

  /* some event messages have no speaker or flag fields */
  if ((*pnEventId != EID_INFO) && (*pnEventId != EID_CHANNELFULL) &&
      (*pnEventId != EID_CHANNEL) &&
      (*pnEventId != EID_CHANNELDOESNOTEXIST) &&
      (*pnEventId != EID_CHANNELRESTRICTED) && (*pnEventId != EID_ERROR)) {

    char szJunk[MAXSTRINGLENGTH];
    sscanf(pszEvent, "%d %s %s %x", pnEventId, szJunk, pszSpeaker, puFlags);
  }

  /* the event text is enclosed in quotes */
  p = strchr(pszEvent, '"');
  if (p) {
    strncpy(pszEventText, p+1, MAXTEXTLENGTH);
    pszEventText[MAXTEXTLENGTH-1] = '\0';

    /* nix the trailing quote */
    p = strrchr(pszEventText, '"');
    if (p)
      *p = '\0';
  }

  return 1;
}


int Dispatch(char *szEventMsg)
{
  int nEventId;
  u_long uFlags;
  char szSpeaker[MAXSTRINGLENGTH] = "";
  char szEventText[MAXTEXTLENGTH] = "";

  if (!ParseEvent(szEventMsg,
                  &nEventId,
                  szSpeaker,
                  &uFlags,
                  szEventText)) {
    return 0;
  }

  /* dispatch to the appropriate event handler */
  switch (nEventId) {
    case EID_SHOWUSER:
      OnShowUser(szSpeaker, uFlags, szEventText);
    break;

    case EID_JOIN:
      OnJoin(szSpeaker, uFlags, szEventText);
    break;

    case EID_USERFLAGS:
      OnUserFlags(szSpeaker, uFlags, szEventText);
    break;

    case EID_LEAVE:
      OnLeave(szSpeaker, uFlags, szEventText);
    break;

    case EID_TALK:
      OnTalk(szSpeaker, uFlags, szEventText);
    break;

    case EID_BROADCAST:
      OnBroadcast(szSpeaker, uFlags, szEventText);
    break;

    case EID_CHANNEL:
      OnChannel(szSpeaker, uFlags, szEventText);
    break;

    case EID_WHISPER:
      OnWhisper(szSpeaker, uFlags, szEventText);
    break;

    case EID_WHISPERSENT:
      OnWhisperSent(szSpeaker, uFlags, szEventText);
    break;

    case EID_EMOTE:
      OnEmote(szSpeaker, uFlags, szEventText);
    break;

    case EID_CHANNELFULL:
      OnChannelFull(szSpeaker, uFlags, szEventText);
    break;

    case EID_CHANNELDOESNOTEXIST:
      OnChannelDoesNotExist(szSpeaker, uFlags, szEventText);
    break;

    case EID_CHANNELRESTRICTED:
      OnChannelRestricted(szSpeaker, uFlags, szEventText);
    break;

    case EID_INFO:
      OnInfo(szSpeaker, uFlags, szEventText);
    break;

    case EID_ERROR:
      OnError(szSpeaker, uFlags, szEventText);
    break;

    case EID_UNIQUENAME:
      OnUniqueName(szSpeaker, uFlags, szEventText);
    break;

    default:
      return 0;
    break;
  }

  return 1;
}


int MsgLoop() {
  int n;
  int nBufLen=0;
  int nBufPos=0;
  char stageBuf[BUFSIZE];
  struct timeval tv;
    
  if (s == INVALID_SOCKET) return 0;

  for (;;) {
    fd_set fds;
    FD_ZERO(&fds);
    FD_SET(s, &fds);
    
    tv.tv_sec = 1;
    tv.tv_usec = 0;

    n = select(s+1, &fds, 0, 0, &tv);
    if (n) {
      int nNumToRead = BUFSIZE-nBufLen-nBufPos;

      if (nNumToRead == 0) {
        memmove(stageBuf, stageBuf+nBufPos, nBufLen);
        nBufPos = 0;
        nNumToRead = BUFSIZE-nBufLen;
      }

      n = recv(s, stageBuf+nBufPos+nBufLen, nNumToRead, 0);
      if (n <= 0) return 0;

      nBufLen += n;

      /* dispatch all complete messages in the staging buffer */
      while (nBufLen > 0) {
        char *m = stageBuf+nBufPos;
        int nMsgLen=0;
        while (nMsgLen < nBufLen) {
          if (m[nMsgLen] == '\n')
            break;
          nMsgLen++;
        }

        nMsgLen++;
        if (nMsgLen > nBufLen)
          break;

        m[nMsgLen-1] = '\0';

        if (isdigit(*m))
          Dispatch(m);

        nBufLen -= nMsgLen;
        nBufPos += nMsgLen;
      }

      if (!nBufLen)
        nBufPos = 0;
    }
    IdleHook();
  }
  return 1;
}


int OnShowUser(char *szSpeaker, u_long uFlags, char *szEventText)
{
  return 1;
}

int OnJoin(char *szSpeaker, u_long uFlags, char *szEventText)
{
  return 1;
}

int OnUserFlags(char *szSpeaker, u_long uFlags, char *szEventText)
{
  return 1;
}

int OnLeave(char *szSpeaker, u_long uFlags, char *szEventText)
{
  return 1;
}


int OnTalk(char *szSpeaker, u_long uFlags, char *szEventText)
{
  return 1;
}


int OnBroadcast(char *szSpeaker, u_long uFlags, char *szEventText)
{
  return 1;
}


int OnChannel(char *szSpeaker, u_long uFlags, char *szEventText)
{
  strcpy(szCurrentChannel, szEventText);
  
  /* Have we just logged on, or have we been kicked out? */
  if ( strcmp( szCurrentChannel, szHomeChannel ) != 0 )
    Send("/join %s\r\n", szHomeChannel);
    
  return 1;
}


int OnWhisper(char *szSpeaker, u_long uFlags, char *szEventText)
{
  return 1;
}

int OnWhisperSent(char *szSpeaker, u_long uFlags, char *szEventText)
{
  return 1;
}

int OnEmote(char *szSpeaker, u_long uFlags, char *szEventText)
{
  return 1;
}

int OnChannelFull(char *szSpeaker, u_long uFlags, char *szEventText)
{
  return 1;
}

int OnChannelDoesNotExist(char *szSpeaker, u_long uFlags,
                          char *szEventText)
{
  return 1;
}

int OnChannelRestricted(char *szSpeaker, u_long uFlags,
                        char *szEventText)
{
  return 1;
}

int OnInfo(char *szSpeaker, u_long uFlags, char *szEventText)
{
  return 1;
}

int OnError(char *szSpeaker, u_long uFlags, char *szEventText)
{
  return 1;
}


int OnUniqueName(char *szSpeaker, u_long uFlags, char *szEventText)
{ 
  strcpy(szUniqueName, szSpeaker);
  return 1;
}

