#ifndef _BNBOT_H_
#define _BNBOT_H_

#include <sys/socket.h>
#include <sys/types.h>
#include <assert.h>
#include <limits.h>
#include <stddef.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <unistd.h>
#include <malloc.h>
#include <string.h>
#include <ctype.h>
#include <signal.h>
#include <stdarg.h>
#include <resolv.h>
#include <netdb.h>

#define MAXSTRINGLENGTH         128
#define MAXTEXTLENGTH           256
#define BUFSIZE			2048

#define BNET_PORT		6112

/* event IDs */
#define EID_SHOWUSER            1001
#define EID_JOIN                1002
#define EID_LEAVE               1003
#define EID_WHISPER             1004
#define EID_TALK                1005
#define EID_BROADCAST           1006
#define EID_CHANNEL             1007      
#define EID_USERFLAGS           1009
#define EID_WHISPERSENT         1010
#define EID_CHANNELFULL         1013
#define EID_CHANNELDOESNOTEXIST 1014
#define EID_CHANNELRESTRICTED   1015
#define EID_INFO                1018
#define EID_ERROR               1019
#define EID_EMOTE               1023
#define EID_UNIQUENAME          2010

#define INVALID_SOCKET		-1


int s;
char szLoginName[MAXSTRINGLENGTH];
char szUniqueName[MAXSTRINGLENGTH];
char szPassword[MAXSTRINGLENGTH];
char szServerAddr[MAXSTRINGLENGTH];
char szHomeChannel[MAXSTRINGLENGTH];
char szCurrentChannel[MAXSTRINGLENGTH];
short nServerPort;


void initialise();

void SetLogonInfo(char *szUserName,
                  char *szUserPass,
                  char *szServer);
void SetHomeChannel(char *szNewChannel);
int Reconnect();
int Connect();
int Logon();
void Disconnect();
int Send(char *szFmt, ...);
int ParseEvent(char *pszEvent, int *pnEventId, char *pszSpeaker,
               u_long *puFlags, char *pszEventText);
int Dispatch(char *szMsg);
int MsgLoop();

void IdleHook() { };

int OnShowUser(char *szSpeaker, u_long uFlags, char *szEventText);
int OnJoin(char *szSpeaker, u_long uFlags, char *szEventText);
int OnUserFlags(char *szSpeaker, u_long uFlags, char *szEventText);
int OnLeave(char *szSpeaker, u_long uFlags, char *szEventText);
int OnTalk(char *szSpeaker, u_long uFlags, char *szEventText);
int OnBroadcast(char *szSpeaker, u_long uFlags, char *szEventText);
int OnChannel(char *szSpeaker, u_long uFlags, char *szEventText);
int OnWhisper(char *szSpeaker, u_long uFlags, char *szEventText);
int OnWhisperSent(char *szSpeaker, u_long uFlags, char *szEventText);
int OnEmote(char *szSpeaker, u_long uFlags, char *szEventText);
int OnChannelFull(char *szSpeaker, u_long uFlags, char *szEventText);
int OnChannelDoesNotExist(char *szSpeaker, u_long uFlags,
                          char *szEventText);
int OnChannelRestricted(char *szSpeaker, u_long uFlags,
                        char *szEventText);
int OnInfo(char *szSpeaker, u_long uFlags, char *szEventText);
int OnError(char *szSpeaker, u_long uFlags, char *szEventText);
int OnUniqueName(char *szSpeaker, u_long uFlags, char *szEventText);


#endif
