#include "main.h"
#include "hashing.h"
#include "checkrevision.h"

#pragma comment(lib, "Version.lib")

struct seed_table seeds[] = {
	{0xA1F3055A, 0x4551FB8F},	//00
	{0x5657124C, 0x81776C47},	//01
	{0x1780AB47, 0x0511663A},	//02
	{0x80B3A410, 0x8839FDF0},	//03
	{0xAF2179EA, 0xEE60E7D6},	//04
	{0x0837B808, 0xB43A6490},	//05
	{0x6F2516C6, 0x246A64BA},	//06
	{0xE3178148, 0x6F6536F1},	//07
	{0x0FCF90B6, 0x3D2C22F0},	//08
	{0xF2F09516, 0x8624FC60},	//09
	{0x378D8D8C, 0x9F30D4E7},	//10
	{0x07F8E083, 0x24A7F246},	//11
	{0xB0EE9741, 0x5AE1F560},	//12
	{0x7923C9AF, 0x3026FF25},	//13
	{0xCA11A05E, 0x0ED32EBF},	//14
	{0xD723C016, 0xFB88CB39},	//15
	{0xFD545590, 0x12BF7406},	//16
	{0xFB600C2E, 0x8B38612E},	//17
	{0x684C8785, 0x95F19E77},	//18
	{0x58BEDE0B, 0x2C0F3DCF},	//19
	{NULL, NULL}
};

int patch_dword(unsigned long AddressToPatch, unsigned long Value) {
    unsigned long OldProtect = 0;
    if(!VirtualProtect((LPVOID)AddressToPatch, 4, PAGE_EXECUTE_READWRITE, &OldProtect))
		return 1;
    *(unsigned long*)AddressToPatch = Value;
    if(!VirtualProtect((LPVOID)AddressToPatch, 4, OldProtect, &OldProtect))
		return 1;
    return 0;
}

int patch_word(unsigned long AddressToPatch, WORD Value) {
    unsigned long OldProtect = 0;
    if(!VirtualProtect((LPVOID)AddressToPatch, 2, PAGE_EXECUTE_READWRITE, &OldProtect))
		return 1;
    *(WORD *)AddressToPatch = Value;
    if(!VirtualProtect((LPVOID)AddressToPatch, 2, OldProtect, &OldProtect))
		return 1;
    return 0;
}

int prepare_backend(HMODULE hLockdown, int file_lock) {
	seed_table patches = seeds[file_lock];
	if(file_lock != 1) {
		int fails = 0;
		fails += patch_dword((DWORD)hLockdown + 0x2067, patches.seed1);
		fails += patch_dword((DWORD)hLockdown + 0x206D, patches.seed2);
		fails += patch_dword((DWORD)hLockdown + 0x2086, patches.seed1);
		fails += patch_word((DWORD)hLockdown + 0x209F, (unsigned short)(patches.seed1 & 0xFF));
		fails += patch_word((DWORD)hLockdown + 0x20B4, (unsigned short)(patches.seed1 & 0xFF));
		return fails;
	}
	return 0;
}

unsigned long get_fileversion(const char *file_path) {
	unsigned long dwBytesRead;
	unsigned long dwSize = GetFileVersionInfoSize((char *)file_path, &dwBytesRead);
	unsigned char *lpbBuffer = (unsigned char *)VirtualAlloc(NULL, dwSize, MEM_COMMIT, PAGE_READWRITE);
	if(!lpbBuffer || !GetFileVersionInfo((char *)file_path, NULL, dwSize, lpbBuffer))
		return 0;
	VS_FIXEDFILEINFO *ffi;
	if(!VerQueryValue(lpbBuffer, "\\", (LPVOID*)&ffi, (PUINT)&dwSize))
		return 0;
	unsigned long dwVersion = ((HIWORD(ffi->dwProductVersionMS) & 0xFF) << 24) |
					((LOWORD(ffi->dwProductVersionMS) & 0xFF) << 16) |
					((HIWORD(ffi->dwProductVersionLS) & 0xFF) << 8) |
					(LOWORD(ffi->dwProductVersionLS) & 0xFF);
	VirtualFree(lpbBuffer, 0lu, MEM_RELEASE);
	return dwVersion;
}

void init_context(SHA1_CTX *context, char *shuffled, int len) {
	memset(context->buffer + 0x44, 0x36, 0x40);
	memset(context->buffer + 0x84, 0x5C, 0x40);
	SHA1InitLD(context);
	for (int x = 0; x < len; x++){
		context->buffer[0x44 + x] ^= shuffled[x];
		context->buffer[0x84 + x] ^= shuffled[x];
	}	
	SHA1UpdateLD(context, (const unsigned char *)context->buffer + 0x44, 0x40);	
}

bool hash_videodump(SHA1_CTX *context, const char *videobuf) {
	char *video_image = (char *)malloc(30720); //new char[30720];
	FILE *dump = fopen(videobuf, "rb");
		fread(video_image, sizeof(BYTE), 30720, dump);
	fclose(dump);
	for(int i = 0; i < 48; i++){
		SHA1UpdateLD(context, (unsigned char *)video_image + (i * 640), 0x0D0);		
	}
	free(video_image);
	//delete [] video_image;
	return true;
}

void double_hash(SHA1_CTX *context, unsigned char result[20]) {
	unsigned char output[20];
	SHA1FinalLD(context, output);
	SHA1InitLD(context);
	SHA1UpdateLD(context, (const unsigned char *)context->buffer + 0x84, 0x40);
	SHA1UpdateLD(context, output, 0x14);
	SHA1FinalLD(context, result);
}

unsigned long finish_sub(unsigned long *arg_one, unsigned long *arg_two) {
	unsigned long edi = *arg_one;
	unsigned long esi = *arg_two;
	unsigned long eax = (edi & 0xffff);
	unsigned long ecx = (eax & 0xff00) >> 8;
	unsigned long edx = (eax & 0xff);
	ecx += edx;
	SET_MASKED_BITS(edx, 0xff, (ecx & 0xff));
	ecx = ecx >> 8;
	ecx += edx;
	bool cf = false;
	if((ecx & 0xff) == 0xff)
		cf = true;
	SET_MASKED_BITS(ecx, 0xff, ((ecx + 1) & 0xff));
	if(!cf)
		SET_MASKED_BITS(ecx, 0xff, ((ecx - 1) & 0xff));
	eax -= ecx;
	bool zf = false;
	unsigned char ah = (unsigned char)(eax & 0xff00) >> 8;
	if(ah == 0xff) {
		SET_MASKED_BITS(eax, 0xff00, 0x0100);
	} else {
		SET_MASKED_BITS(eax, 0xff00, 0x0000);
	}	   	
	SET_MASKED_BITS(eax, 0xff, ~((eax) & 0xff) + 1);
	*arg_one = (eax & 0xffff);
	*arg_two = (ecx & 0xffff);
	return *arg_one;
}

int finish(unsigned char *arg_output, unsigned int *arg_output_length, unsigned char *arg_heap, int arg_10h) {
	unsigned char *var_output_byte = arg_output;
	int var_return_value = 0, var_iterations1 = 0;
	for(var_return_value = 1; 1; var_iterations1++) {
		int var_heap_index = arg_10h;
		if(!var_heap_index)
			break;
		do {
			if(*(arg_heap + var_heap_index - 1) != 0)
				break;
			arg_10h = var_heap_index;
		} while(var_heap_index--);
		if(!var_heap_index)
			break;
		unsigned long eax = 0;
		unsigned long var_unknown_0C = 0;
		for(var_unknown_0C = 0; 1; eax = var_unknown_0C) {
			var_heap_index--;
			unsigned long cx = *(arg_heap + var_heap_index) & 0xFFFF;
			eax = (eax << 8) + (cx & 0xFFFF);
			unsigned long var_modified_heap_byte = eax;
			finish_sub(&var_modified_heap_byte, &var_unknown_0C);
			*(arg_heap + var_heap_index) = (unsigned char)var_modified_heap_byte;
			if(var_heap_index <= 0)
				break;
		}
		if((unsigned long)var_iterations1 < *arg_output_length) {
            *var_output_byte = (unsigned char)var_unknown_0C + 1;
		} else {
			var_return_value = 0;
		}
		var_output_byte++;
	}
	arg_output_length = (unsigned int*)(var_output_byte - arg_output); 
	return var_return_value;
}

int CheckRevisionLD(const char *file_game, const char *file_strm, const char *file_bttl,
						   const char *server_hash, unsigned long &out_version, unsigned long &out_checksum,
						   char *out_digest, const char *file_lock, const char *file_vdmp) {
	if(HMODULE hLockdown = LoadLibrary("lockdown-IX86-01.dll")) {
		char *digit_ptr = strchr((char*)file_lock, '.');
		if(!digit_ptr)
			return 1;
		int digit_1 = (int)(*(digit_ptr - 1) - '0');
		int digit_2 = (int)(*(digit_ptr - 2) - '0');
		if(digit_2 == 1)
			digit_1 += 10;
		if(digit_1 < 0 || digit_1 > 19)
			return 2;
		if(prepare_backend(hLockdown, digit_1))
			return 3;
		lcr_shuf shuffle_serverhash	= (lcr_shuf)((char*)hLockdown + 0x1A0E);
		lcr_hash hash_gamefile		= (lcr_hash)((char*)hLockdown + 0x24E1);
		if(!shuffle_serverhash || !hash_gamefile)
			return 4;
		unsigned long file_version = get_fileversion(file_game);
		if(!file_version)
			return 5;
		int hash_length = 0;
		hash_length = strlen(server_hash);
		if(!hash_length || hash_length < 16 || hash_length > 17)
			return 6;
		char shuffled_server_hash[64] = {0};
		if(!shuffle_serverhash(shuffled_server_hash, hash_length, server_hash, hash_length))
			return 7;
		SHA1_CTX context;
		init_context(&context, shuffled_server_hash, hash_length);
		HMODULE file_handles[4] = {0};
		file_handles[0] = LoadLibrary(file_lock);
		file_handles[1] = LoadLibrary(file_game);
		file_handles[2] = LoadLibrary(file_strm);
		file_handles[3] = LoadLibrary(file_bttl);									   
		if (!file_handles[0] || !file_handles[1] || !file_handles[2] || !file_handles[3])
			return 8;						 
		for (int x = 0; x <= 3; x++) {
			hash_gamefile(&context, file_handles[x]);
			FreeLibrary(file_handles[x]);
		}
		if (!hash_videodump(&context, file_vdmp))
			return 9;
		SHA1UpdateLD(&context, (const unsigned char *)"\x01\x00\x00\x00", 4);
		SHA1UpdateLD(&context, (const unsigned char *)"\x00\x00\x00\x00", 4);
		unsigned char dblhash_result[20];
		double_hash(&context, dblhash_result);
		memmove(&out_checksum, dblhash_result, 4);
		unsigned int ret = 17;
		if (!finish((unsigned char*)out_digest, &ret, dblhash_result + 4, 16))
			return 10;
		out_version = file_version;
		FreeLibrary(hLockdown);
		return 0;
	}
	return 11;
}