#include "main.h"
#include "fxns.h"

void GetStuff(char *section, char *key, char *output, int len) {
	char asdf[MAX_PATH];
	strcpy(asdf, CurrDir);
	strcat(asdf, "\\config.ini");
	GetPrivateProfileString(section, key, NULL, output, len, asdf);													
}

char *lcase(char *str) {
	char *tmp = str;
	while (*tmp = tolower(*tmp))
		tmp++;
	return str;
}

void AddChat(COLORREF color, char *text) {
	char buf[16];
	cfFormat.crTextColor = 0xD0D0D0;
	CHARRANGE cr = {-1, -1};
	HWND hwnd = hWnd_rtfChat;	 ///////////
	SendMessage(hwnd, EM_EXSETSEL, 0, (LPARAM)&cr);
	SendMessage(hwnd, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM)&cfFormat);
	SendMessage(hwnd, EM_REPLACESEL, false, (LPARAM)TimeStamp(buf));
	cfFormat.crTextColor = color;
	SendMessage(hwnd, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM)&cfFormat);
	SendMessage(hwnd, EM_REPLACESEL, false, (LPARAM)text);
	SendMessage(hwnd, EM_REPLACESEL, false, (LPARAM)"\r\n");
	SendMessage(hwnd, EM_SCROLL, SB_BOTTOM, 0);
}


void AddChatEx(COLORREF color, char *text, ...) {
	char buf[16], asdf[1024];
	cfFormat.crTextColor = 0xD0D0D0;
	CHARRANGE cr = {-1, -1};
	HWND hwnd = hWnd_rtfChat;	 ///////////
	SendMessage(hwnd, EM_EXSETSEL, 0, (LPARAM)&cr);
	SendMessage(hwnd, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM)&cfFormat);
	SendMessage(hwnd, EM_REPLACESEL, false, (LPARAM)TimeStamp(buf));
	cfFormat.crTextColor = color;
	SendMessage(hwnd, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM)&cfFormat);
	va_list args;
	va_start(args, text);
	vsprintf(asdf, text, args);
	va_end(args);
	SendMessage(hwnd, EM_REPLACESEL, false, (LPARAM)asdf);
	SendMessage(hwnd, EM_REPLACESEL, false, (LPARAM)"\r\n");
	SendMessage(hwnd, EM_SCROLL, SB_BOTTOM, 0);
}


void AppendText(COLORREF Color, char *szFmt) {
	CHARRANGE cr = {-1, -1};
	cfFormat.crTextColor = Color;
	HWND hwnd = hWnd_rtfChat; ////////////
	SendMessage(hwnd, EM_EXSETSEL, 0, (LPARAM)&cr);
	SendMessage(hwnd, EM_SETCHARFORMAT, SCF_SELECTION, (LPARAM)&cfFormat);
	SendMessage(hwnd, EM_REPLACESEL, false, (LPARAM)szFmt);
	SendMessage(hwnd, EM_EXSETSEL, 0, (LPARAM)&cr);
	SendMessage(hwnd, EM_SCROLL, SB_BOTTOM, 0);
}

char *TimeStamp(char *buf) {
	SYSTEMTIME st;
	GetLocalTime(&st);
	if (!st.wHour) 
		st.wHour = 12;
	sprintf(buf, "[%02i:%02i:%02i %cM] ",
		(st.wHour > 12) ? st.wHour % 12 : st.wHour,
		st.wMinute, st.wSecond, (st.wHour > 12) ? 'P' : 'A');
	return buf;
}

int GetResultCode(char *buf) {
	lcase(buf);
	switch (*(int *)buf) {
		case 'niw':
			return 1;
		case 'esol':
			return 2;
		case 'ward':
			return 3;
		case 'csid':
			return 4;
		default:
			AddChatEx(vbRed, "Invalid game result: %s!", buf);
			return 0;
	}
}

bool ConnectSocket(SOCKET *sck, char *server, unsigned short port) {
	struct sockaddr_in sName;
	*sck = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
	if (*sck == INVALID_SOCKET)
		return false;
	sName.sin_family = AF_INET;
	sName.sin_port = htons(port);
	char *p = server;
	while (*p && (isdigit(*p) || (*p == '.')))
		p++;
	if (*p) {
		struct hostent *hstEnt = gethostbyname(server);
		memcpy(&sName.sin_addr, hstEnt->h_addr, hstEnt->h_length);
	} else {
		sName.sin_addr.s_addr = inet_addr(server);
	}
	if (connect(*sck, (struct sockaddr *)&sName, sizeof(sName)))
		return false;
	return true;
}


void LoadStarcraftImage() {
	unsigned long read;	
	HANDLE hfStarCraft = CreateFile(hashes[0], GENERIC_READ, 0, NULL, OPEN_EXISTING, 0, NULL);
	if (hfStarCraft == INVALID_HANDLE_VALUE) {
		AddChatEx(vbRed, "Failed to open starcraft.exe!");
		return;
	}
	int filesize = GetFileSize(hfStarCraft, NULL);
	lpSCImage = (char *)malloc(filesize);
	ReadFile(hfStarCraft, lpSCImage, filesize, &read, NULL);
	CloseHandle(hfStarCraft);								
	if (*(__int16 *)lpSCImage != 'ZM')
		AddChatEx(vbRed, "Starcraft.exe PE Header corrupted!");																		
}


//////////////////////////////////////////////////[TRAY]////////////////////////////////////////////////////////

void TrayAdd() {
	ShowWindow(hWnd_main, SW_HIDE);
	Shell_NotifyIcon(NIM_ADD, &note);
}

void TrayRestore() {
	ShowWindow(hWnd_main, SW_SHOW);
	ShowWindow(hWnd_main, SW_RESTORE);
	Shell_NotifyIcon(NIM_DELETE, &note);
}

