#include "main.h"
#include "hashing.h"

#define ROL(nr, shift)	((nr << shift) | (nr >> (32 - shift)))

void DoubleHashPass(char *firsthash, unsigned int ClientToken, unsigned int ServerToken, char *buf) {
    char asdf[28];
	*(__int32 *)(asdf)	   = ClientToken;
	*(__int32 *)(asdf + 4) = ServerToken;
	memcpy(asdf + 8, firsthash, 20);
	BSHA1(asdf, 28, (unsigned long *)buf);
}

void MD5(char *source, unsigned long len, char *output) {
	unsigned long hashlen = 16;
	CryptHashCertificate(NULL, CALG_MD5, 0, (const unsigned char *)source,
		len, (unsigned char *)output, &hashlen);
}

void SHA1(char *source, unsigned long len, char *output) {
	unsigned long hashlen = 20;
	CryptHashCertificate(NULL, 0, 0, (const unsigned char *)source,
		len, (unsigned char *)output, &hashlen);
}

void BSHA1(const void *src, const int len, unsigned long *result) {
    unsigned long a = 0x67452301lu, b = 0xefcdab89lu;
    unsigned long c = 0x98badcfelu, d = 0x10325476lu;
    unsigned long e = 0xc3d2e1f0lu, g;
    unsigned char bBuffer [320] = {0};
    memcpy(bBuffer, src, len);
    unsigned long *lpdwBuffer = (unsigned long *) bBuffer;
    for (int i = 0; i < 80; ++i) {
		if (i < 64)
			lpdwBuffer [i + 16] = ROL(1, (lpdwBuffer [i] ^ lpdwBuffer [i + 8] ^ lpdwBuffer [i + 2] ^ lpdwBuffer [i + 13]) % 32);
		if (i < 20)
			g = lpdwBuffer[i] + ROL(a, 5) + e + ((b & c) | (~b & d)) + 0x5a827999lu;
		else if (i < 40)
			g = (d ^ c ^ b) + e + ROL(g, 5) + lpdwBuffer[i] + 0x6ed9eba1lu;
		else if (i < 60)
			g = lpdwBuffer[i] + ROL(g, 5) + e + ((c & b) | (d & c) | (d & b)) - 0x70e44324lu;
		else
			g = (d ^ c ^ b) + e + ROL(g, 5) + lpdwBuffer[i] - 0x359d3e2alu;
		e = d;
		d = c;
		c = ROL(b, 30);
		b = a;
		a = g;
    }
    result [0] = 0x67452301lu + g;
    result [1] = 0xefcdab89lu + b;
    result [2] = 0x98badcfelu + c;
    result [3] = 0x10325476lu + d;
    result [4] = 0xc3d2e1f0lu + e;
}

//////////////////////////////LD

void SHA1InitLD(SHA1_CTX* context) {   
    context->state[0] = 0x67452301;
    context->state[1] = 0xEFCDAB89;
    context->state[2] = 0x98BADCFE;
    context->state[3] = 0x10325476;
    context->state[4] = 0xC3D2E1F0;
    context->count[0] = context->count[1] = 0;
}

void SHA1UpdateLD(SHA1_CTX* context, const unsigned char* data, unsigned int len) {
	unsigned int i, j;
    j = (context->count[0] >> 3) & 63;
    if ((context->count[0] += len << 3) < (len << 3)) context->count[1]++;
    context->count[1] += (len >> 29);
    if ((j + len) > 63) {
        memcpy(&context->buffer[j], data, (i = 64-j));
        SHA1TransformLD(context->state, context->buffer);
        for ( ; i + 63 < len; i += 64) {
            SHA1TransformLD(context->state, &data[i]);
        }
        j = 0;
    }
    else i = 0;
    memcpy(&context->buffer[j], &data[i], len - i);
}

void SHA1FinalLD(SHA1_CTX* context, unsigned char digest[20]) {			
	unsigned char buffer[64];
	buffer[0] = (unsigned char)0x80;	
	for (int p=1;p<sizeof(buffer); p++ ){
		buffer[p] = (unsigned char)0x00;
	}
	unsigned char finalcount[8];
    for(int i = 0; i < 8; i++)
		finalcount[7-i] = (unsigned char)((context->count[(i >= 4 ? 0 : 1)] >> ((3-(i & 3)) * 8) ) & 255);
	LARGE_INTEGER li;
	li.LowPart = context->count[1];
	li.HighPart = context->count[0];
	li.QuadPart >>= 0x03;		
	context->count[1] >>= 0x03;	
	unsigned int len = ((0xFFFFFFF7 - li.HighPart) & 0x3f) + 1;	
	SHA1UpdateLD(context, (unsigned char*)buffer, len);
	SHA1UpdateLD(context, finalcount, 8);
	for(i = 0; i < 20; i++)
		digest[i] = (unsigned char)((context->state[i>>2] >> ((3-((19-i) & 3)) * 8) ) & 255);
}

void SHA1TransformLD(unsigned int state[5], const unsigned char buffer[64]) {
	unsigned int a, b, c, d, e;
	typedef union {
		unsigned char c[64];
		unsigned int l[16];
	} CHAR64LONG16;
	CHAR64LONG16* block;
    block = (CHAR64LONG16*)buffer;
    a = state[0];
    b = state[1];
    c = state[2];
    d = state[3];
    e = state[4];
    R0(a,b,c,d,e, 0); R0(e,a,b,c,d, 1); R0(d,e,a,b,c, 2); R0(c,d,e,a,b, 3);
    R0(b,c,d,e,a, 4); R0(a,b,c,d,e, 5); R0(e,a,b,c,d, 6); R0(d,e,a,b,c, 7);
    R0(c,d,e,a,b, 8); R0(b,c,d,e,a, 9); R0(a,b,c,d,e,10); R0(e,a,b,c,d,11);
    R0(d,e,a,b,c,12); R0(c,d,e,a,b,13); R0(b,c,d,e,a,14); R0(a,b,c,d,e,15);
    R1(e,a,b,c,d,16); R1(d,e,a,b,c,17); R1(c,d,e,a,b,18); R1(b,c,d,e,a,19);
    R2(a,b,c,d,e,20); R2(e,a,b,c,d,21); R2(d,e,a,b,c,22); R2(c,d,e,a,b,23);
    R2(b,c,d,e,a,24); R2(a,b,c,d,e,25); R2(e,a,b,c,d,26); R2(d,e,a,b,c,27);
    R2(c,d,e,a,b,28); R2(b,c,d,e,a,29); R2(a,b,c,d,e,30); R2(e,a,b,c,d,31);
    R2(d,e,a,b,c,32); R2(c,d,e,a,b,33); R2(b,c,d,e,a,34); R2(a,b,c,d,e,35);
    R2(e,a,b,c,d,36); R2(d,e,a,b,c,37); R2(c,d,e,a,b,38); R2(b,c,d,e,a,39);
    R3(a,b,c,d,e,40); R3(e,a,b,c,d,41); R3(d,e,a,b,c,42); R3(c,d,e,a,b,43);
    R3(b,c,d,e,a,44); R3(a,b,c,d,e,45); R3(e,a,b,c,d,46); R3(d,e,a,b,c,47);
    R3(c,d,e,a,b,48); R3(b,c,d,e,a,49); R3(a,b,c,d,e,50); R3(e,a,b,c,d,51);
    R3(d,e,a,b,c,52); R3(c,d,e,a,b,53); R3(b,c,d,e,a,54); R3(a,b,c,d,e,55);
    R3(e,a,b,c,d,56); R3(d,e,a,b,c,57); R3(c,d,e,a,b,58); R3(b,c,d,e,a,59);
    R4(a,b,c,d,e,60); R4(e,a,b,c,d,61); R4(d,e,a,b,c,62); R4(c,d,e,a,b,63);
    R4(b,c,d,e,a,64); R4(a,b,c,d,e,65); R4(e,a,b,c,d,66); R4(d,e,a,b,c,67);
    R4(c,d,e,a,b,68); R4(b,c,d,e,a,69); R4(a,b,c,d,e,70); R4(e,a,b,c,d,71);
    R4(d,e,a,b,c,72); R4(c,d,e,a,b,73); R4(b,c,d,e,a,74); R4(a,b,c,d,e,75);
    R4(e,a,b,c,d,76); R4(d,e,a,b,c,77); R4(c,d,e,a,b,78); R4(b,c,d,e,a,79);
    state[0] += a;
    state[1] += b;
    state[2] += c;
    state[3] += d;
    state[4] += e;   
    a = b = c = d = e = 0;
}
