/******************
 *				  *
 *     Winbot	  *
 *     by brew    *
 *			      *
 ******************/
#include "main.h"
#include "fxns.h"
#include "cdkey.h"
#include "hashing.h"
#include "packets.h"

HINSTANCE hInst;
HWND hWnd_main, hWnd_Statusbar, hWnd_rtfChat;	 
NOTIFYICONDATA note;
HMODULE hRichEdit;
HMENU hMenu;
CHARFORMAT cfFormat;
char CurrDir[MAX_PATH];

BOT bot[2];
char server[32];
char home[64];
char gamename[64];
char mapname[64];
int verbyte, timeingame, client, games;
char hashes[5][MAX_PATH];

UINT wm_taskbar;

char *lpSCImage;

int gstate;

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow) {
	MSG msg;
	WNDCLASS wc;
	hInst = hInstance;
	wc.style         = CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc   = WndProc;
	wc.cbClsExtra    = 0;
	wc.cbWndExtra    = 0;	
	wc.hInstance     = hInstance;
	wc.hIcon         = LoadIcon(NULL, MAKEINTRESOURCE(100));
	wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = (HBRUSH) (COLOR_WINDOW);
	wc.lpszMenuName  = NULL;
	wc.lpszClassName = szAppName;
	RegisterClass(&wc);
	hWnd_main = CreateWindow(szAppName, szAppName, WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN, CW_USEDEFAULT, CW_USEDEFAULT, 300, 200, NULL, NULL, hInstance, NULL);			
	ShowWindow(hWnd_main, iCmdShow);
	RedrawWindow(hWnd_main, NULL, NULL, RDW_INVALIDATE | RDW_ERASE | RDW_ALLCHILDREN);
	while (GetMessage(&msg, NULL, 0, 0)) {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}				  
	return msg.wParam;
}

LRESULT CALLBACK WndProc(HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam) {
	switch (iMsg) {
		case WM_CREATE:
			hWnd_main = hwnd;
			init(hwnd);
			AddChat(0xC0A090, " >> Epic Winrar 1.0");
			AddChat(0x907050, " >>    By BreW");
			break;
		case WM_SIZE:
			if (wParam == SIZE_MINIMIZED)
				TrayAdd();
			MoveWindow(hWnd_rtfChat, 0, 0, LOWORD(lParam), HIWORD(lParam) - 22, true);
			MoveWindow(hWnd_Statusbar, 0, 0, 0, 0, true);
			break;
		case WM_GETMINMAXINFO:
			LPMINMAXINFO minmax;
			minmax = (LPMINMAXINFO)lParam;
			minmax->ptMinTrackSize.x = 300;
			minmax->ptMinTrackSize.y = 200;
			break;
		case WM_SHELLNOTIFY:
			if (lParam == WM_RBUTTONUP || lParam == WM_LBUTTONUP)
				TrayRestore();
			break;
		case WM_COMMAND:
			int tmp;
			tmp = 0;
			switch (LOWORD(wParam)) {
				case ID_BOT_EXIT:
					SendMessage(hwnd, WM_CLOSE, 0, 0);
					break;
				case ID_BOT_BOT2:
					tmp++;
				case ID_BOT_BOT1:
					CreateThread(NULL, 0, (LPTHREAD_START_ROUTINE)RecvProc, (LPVOID)tmp, 0, NULL);
					break;
				case ID_OPEN_FOLDER:
					ShellExecute(hwnd, NULL, CurrDir, NULL, "C:\\", 1);
					break;
				case ID_OPEN_CONFIGINI:
					char path[MAX_PATH];
					sprintf(path, "%s\\config.ini", CurrDir);
					ShellExecute(hwnd, NULL, path, NULL, "C:\\", 1);
					break;
				case ID_RELOADCONFIG:
					LoadConfig();
					AddChat(vbGreen, "Config reloaded!");
					break;
				case ID_STARTWINBOTTING:
					if (gstate & GS_READY) {
						if (gstate & GS_WINBOTTING) {
							KillTimer(hWnd_main, 1);
							AddChat(vbGreen, "Winbotting stopped.");
							SendMessage(hWnd_Statusbar, SB_SETTEXT, 0, (LPARAM)"Ready");
						} else {
							Send0x1C(0, false);
							Send0x22(1);
							SetTimer(hWnd_main, 1, 1000, CreateGame);
							games--;
							SendMessage(hWnd_Statusbar, SB_SETTEXT, 0, (LPARAM)"Winbotting!");
							AddChat(vbGreen, "Winbotting started!");
						}
					}
					break;
			}	
			break;
		//case WM_CTLCOLORSTATIC:
		//case WM_CTLCOLOREDIT:
		//	return (LRESULT)BLACK_BRUSH;
		case WM_CLOSE:
			DestroyWindow(hwnd);
			FreeLibrary(hRichEdit);
			WSACleanup();
			break;
		case WM_DESTROY:
			PostQuitMessage(0);
			break;
		default:
			if (iMsg == wm_taskbar) {
				if (IsIconic(hwnd))
					TrayAdd();
			} else {
				return DefWindowProc(hwnd, iMsg, wParam, lParam);
			}
	}
	return 0;
}

VOID CALLBACK CreateGame(HWND hwnd, UINT uMsg, UINT_PTR idEvent, DWORD dwTime) {
	KillTimer(hWnd_main, 1);
	Send0x1C(0, true);
	SetTimer(hWnd_main, 1, timeingame * 1000, NewGame);
	games--;
}

VOID CALLBACK NewGame(HWND hwnd, UINT uMsg, UINT_PTR idEvent, DWORD dwTime) {
	char buf[32];
	KillTimer(hWnd_main, 1);
	if (!games) {
		AddChat(vbGreen, "Done winbotting!");
		return;
	}
	Send0x2C(0);
	Send0x2C(1);
	Sleep(1000);
	Send0x1C(0, false);
	Send0x22(1);
	SetTimer(hWnd_main, 1, 1000, CreateGame);
	AddChat(vbGreen, "Creating new game...");
	sprintf(buf, "%d left", games);
	SendMessage(hWnd_Statusbar, SB_SETTEXT, 1, (LPARAM)buf);
}
  
void init(HWND hwnd) {
	WSADATA wsadata;

	GetCurrentDirectory(MAX_PATH, CurrDir);

	note.cbSize = sizeof(NOTIFYICONDATA);
	note.hIcon = LoadIcon(NULL, MAKEINTRESOURCE(100));
	note.hWnd = hwnd;
	note.uCallbackMessage = WM_SHELLNOTIFY;
	strcpy(note.szTip, szAppName);
	note.uID = 200;
	note.uFlags = NIF_ICON | NIF_MESSAGE | NIF_TIP;

	cfFormat.cbSize = sizeof(CHARFORMAT);
	cfFormat.dwMask = CFM_COLOR | CFM_FACE | CFM_SIZE | CFM_BOLD;
	cfFormat.yHeight = 0xAA;
	cfFormat.dwEffects = 0;
	strcpy(cfFormat.szFaceName, "Tahoma");

	hMenu = LoadMenu(hInst, MAKEINTRESOURCE(IDR_MENU1));
	SetMenu(hwnd, hMenu);
	DrawMenuBar(hwnd);

	int parts[4] = {100, 200, 300, 400};
	hWnd_Statusbar = CreateWindow(STATUSCLASSNAME, szAppName, SBARS_SIZEGRIP | WS_CHILD | WS_VISIBLE, 0, 0, 0, 0, hwnd, (HMENU)30, hInst, NULL);
	SendMessage(hWnd_Statusbar, SB_SETPARTS, 4, (LPARAM)parts);
	
	hRichEdit = LoadLibrary("riched32.dll");
	hWnd_rtfChat = CreateWindow(RICHEDIT_CLASS, NULL,
		WS_CHILD | WS_VISIBLE | ES_MULTILINE | ES_AUTOVSCROLL | WS_BORDER | ES_READONLY | WS_VSCROLL,
		0, 0, 302, 180, hwnd, (HMENU)31, hInst, NULL);

	wm_taskbar = RegisterWindowMessage("TaskbarCreated");

	WSAStartup(0x0202, &wsadata);

	LoadConfig();
	LoadStarcraftImage();
}

void LoadConfig() {
	char buf[64], tmp[16];
	GetStuff("Main", "Server", server, sizeof(server));
	GetStuff("Main", "HomeChannel", home, sizeof(home));
	GetStuff("Main", "Verbyte", buf, sizeof(buf));
	sscanf(buf, "%02X", &verbyte);
	GetStuff("Main", "TimeInGame", buf, sizeof(buf));
	timeingame = atoi(buf);	
	GetStuff("Main", "Client", buf, sizeof(buf));
	fastswap32((unsigned long *)buf);
	client = *(__int32 *)buf;
	GetStuff("Main", "Games", buf, sizeof(buf));
	games = atoi(buf);
	GetStuff("Main", "GameName", gamename, sizeof(gamename));
	GetStuff("Main", "MapName", mapname, sizeof(mapname));
	for (int i = 0; i != NUM_HASHES; i++) {
		sprintf(tmp, "Hash%d", i);
		GetStuff("Hashes", tmp, hashes[i], sizeof(hashes[i]));
	}
	for (i = 0; i != 2; i++) {
		sprintf(tmp, "Bot%d", i);
		GetStuff(tmp, "Username", bot[i].username, sizeof(bot[i].username));
		GetStuff(tmp, "Password", buf, sizeof(buf));
		BSHA1(buf, strlen(buf), (unsigned long *)bot[i].password);
		GetStuff(tmp, "CDKey", buf, sizeof(buf));
		DecodeKey(buf, &bot[i].cdkey, i);
		GetStuff(tmp, "GameResult", buf, sizeof(buf));
		bot[i].gameresult = GetResultCode(buf);
	}
}
		
int RecvProc(int index) {	 
	AddChatEx(vbYellow, "[%d] Connecting to %s...", index, server);
	if (!ConnectSocket(&bot[index].sck, server, 6112)) {
		AddChatEx(vbRed, "[%d] Winsock connect error %d!", index, WSAGetLastError());
		return 0;
	}
	AddChatEx(vbGreen, "[%d] Connected!", index);
	send(bot[index].sck, "\x01", 1, 0);
	Send0x50(index);
	char recvbuf[16384];
	while (1) {	
		char *wsdata = recvbuf;
		int recvlen = recv(bot[index].sck, recvbuf, sizeof(recvbuf), 0);
		if (!recvlen || recvlen == SOCKET_ERROR) {
			AddChatEx(vbRed, "[%d] Winsock error!", index);
			return 0;
		}
		while (recvlen >= 4) {
			if ((unsigned char)*wsdata != (unsigned char)0xFF) {
				AddChatEx(vbRed, "[%d] Packet sanity check failed!", index);
				break;
			}
			int bnetlen = *(unsigned short *)(wsdata + 2);
			if (bnetlen > recvlen) {
				AddChatEx(vbYellow, "[%d] Expecting %d more bytes.", index, bnetlen - recvlen);
				if (wsdata + recvlen >= recvbuf + sizeof(recvbuf)) {
					memcpy(recvbuf, wsdata, recvlen);
					wsdata = recvbuf;
				}
				if (bnetlen > recvlen) {
					int tmp = recv(bot[index].sck, wsdata + recvlen, sizeof(recvbuf) - (wsdata - recvbuf) - recvlen, 0);
					if (!tmp || tmp == SOCKET_ERROR) {
						AddChat(vbRed, "Winsock error!!!");
						return 0;
					}
					recvlen += tmp;
				}
			}
			ParsePacket(wsdata[1], wsdata, index); 
			wsdata += bnetlen;
			recvlen -= bnetlen;
		}
	}
}
